/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.packages;

import java.io.PrintStream;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.karaf.shell.packages.PackageCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

@Command(scope="packages", name="exports", description="Display exported packages")
public class ExportsCommand
extends PackageCommandSupport {
    @Option(name="-i", aliases={"--imports"}, description="List bundles importing the specified packages")
    boolean imports;
    @Argument(index=0, name="ids", description="The IDs of bundles to check", required=false, multiValued=true)
    List<Long> ids;

    protected void doExecute(PackageAdmin admin) throws Exception {
        if (this.ids != null && !this.ids.isEmpty()) {
            for (long id : this.ids) {
                Bundle bundle = this.getBundleContext().getBundle(id);
                if (bundle != null) {
                    this.printExports(System.out, bundle, admin.getExportedPackages(bundle));
                    continue;
                }
                System.err.println("Bundle ID " + id + " is invalid.");
            }
        } else {
            this.printExports(System.out, null, admin.getExportedPackages((Bundle)null));
        }
    }

    protected void printExports(PrintStream out, Bundle target, ExportedPackage[] exports) {
        if (exports != null && exports.length > 0) {
            for (int i = 0; i < exports.length; ++i) {
                Bundle[] bs;
                Bundle bundle = exports[i].getExportingBundle();
                out.print(ExportsCommand.getBundleName(bundle));
                out.println(": " + exports[i]);
                if (!this.imports || (bs = exports[i].getImportingBundles()) == null) continue;
                for (Bundle b : bs) {
                    out.println("\t" + ExportsCommand.getBundleName(b));
                }
            }
        } else {
            out.println(ExportsCommand.getBundleName(target) + ": No active exported packages.");
        }
    }

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name + " (" + Long.toString(bundle.getBundleId()) + ")";
        }
        return "[STALE BUNDLE]";
    }
}

