/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.management.openmbean.CompositeData;
import org.apache.aries.jmx.codec.BatchActionResult;
import org.apache.aries.jmx.codec.BatchInstallResult;
import org.apache.aries.jmx.util.FrameworkUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class Framework
implements FrameworkMBean {
    private StartLevel startLevel;
    private PackageAdmin packageAdmin;
    private BundleContext context;

    public Framework(BundleContext context, StartLevel startLevel, PackageAdmin packageAdmin) {
        this.context = context;
        this.startLevel = startLevel;
        this.packageAdmin = packageAdmin;
    }

    public int getFrameworkStartLevel() throws IOException {
        return this.startLevel.getStartLevel();
    }

    public int getInitialBundleStartLevel() throws IOException {
        return this.startLevel.getInitialBundleStartLevel();
    }

    public long installBundle(String location) throws IOException {
        try {
            Bundle bundle = this.context.installBundle(location);
            return bundle.getBundleId();
        }
        catch (BundleException e) {
            IOException ioex = new IOException("Can't install bundle with location " + location);
            ioex.initCause(e);
            throw ioex;
        }
    }

    public long installBundleFromURL(String location, String url) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.createStream(url);
            Bundle bundle = this.context.installBundle(location, inputStream);
            return bundle.getBundleId();
        }
        catch (BundleException e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            IOException ioex = new IOException("Can't install bundle with location " + location);
            ioex.initCause(e);
            throw ioex;
        }
    }

    public InputStream createStream(String url) throws IOException {
        return new URL(url).openStream();
    }

    public CompositeData installBundles(String[] locations) throws IOException {
        if (locations == null) {
            return new BatchInstallResult("Failed to install bundles locations can't be null").toCompositeData();
        }
        long[] ids = new long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            try {
                long id;
                ids[i] = id = this.installBundle(locations[i]);
                continue;
            }
            catch (Throwable t) {
                long[] completed = new long[i];
                System.arraycopy(ids, 0, completed, 0, i);
                String[] remaining = new String[locations.length - i - 1];
                System.arraycopy(locations, i + 1, remaining, 0, remaining.length);
                return new BatchInstallResult(completed, t.toString(), remaining, locations[i]).toCompositeData();
            }
        }
        return new BatchInstallResult(ids).toCompositeData();
    }

    public CompositeData installBundlesFromURL(String[] locations, String[] urls) throws IOException {
        if (locations == null || urls == null) {
            return new BatchInstallResult("Failed to install bundles arguments can't be null").toCompositeData();
        }
        if (locations.length != urls.length) {
            return new BatchInstallResult("Failed to install bundles size of arguments should be same").toCompositeData();
        }
        long[] ids = new long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            try {
                long id;
                ids[i] = id = this.installBundleFromURL(locations[i], urls[i]);
                continue;
            }
            catch (Throwable t) {
                long[] completed = new long[i];
                System.arraycopy(ids, 0, completed, 0, i);
                String[] remaining = new String[locations.length - i - 1];
                System.arraycopy(locations, i + 1, remaining, 0, remaining.length);
                return new BatchInstallResult(completed, t.toString(), remaining, locations[i]).toCompositeData();
            }
        }
        return new BatchInstallResult(ids).toCompositeData();
    }

    public void refreshBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        this.packageAdmin.refreshPackages(new Bundle[]{bundle});
    }

    public void refreshBundles(long[] bundleIdentifiers) throws IOException {
        Bundle[] bundles = null;
        if (bundleIdentifiers != null) {
            bundles = new Bundle[bundleIdentifiers.length];
            for (int i = 0; i < bundleIdentifiers.length; ++i) {
                bundles[i] = FrameworkUtils.resolveBundle(this.context, bundleIdentifiers[i]);
            }
        }
        this.packageAdmin.refreshPackages(bundles);
    }

    public boolean resolveBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        return this.packageAdmin.resolveBundles(new Bundle[]{bundle});
    }

    public boolean resolveBundles(long[] bundleIdentifiers) throws IOException {
        Bundle[] bundles = null;
        if (bundleIdentifiers != null) {
            bundles = new Bundle[bundleIdentifiers.length];
            for (int i = 0; i < bundleIdentifiers.length; ++i) {
                bundles[i] = FrameworkUtils.resolveBundle(this.context, bundleIdentifiers[i]);
            }
        }
        return this.packageAdmin.resolveBundles(bundles);
    }

    public void restartFramework() throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, 0L);
        try {
            bundle.update();
        }
        catch (BundleException be) {
            IOException ioex = new IOException("Failed to restart framework");
            ioex.initCause(be);
            throw ioex;
        }
    }

    public void setBundleStartLevel(long bundleIdentifier, int newlevel) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        this.startLevel.setBundleStartLevel(bundle, newlevel);
    }

    public CompositeData setBundleStartLevels(long[] bundleIdentifiers, int[] newlevels) throws IOException {
        if (bundleIdentifiers == null || newlevels == null) {
            return new BatchActionResult("Failed to setBundleStartLevels arguments can't be null").toCompositeData();
        }
        if (bundleIdentifiers != null && newlevels != null && bundleIdentifiers.length != newlevels.length) {
            return new BatchActionResult("Failed to setBundleStartLevels size of arguments should be same").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.setBundleStartLevel(bundleIdentifiers[i], newlevels[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    public void setFrameworkStartLevel(int newlevel) throws IOException {
        this.startLevel.setStartLevel(newlevel);
    }

    public void setInitialBundleStartLevel(int newlevel) throws IOException {
        this.startLevel.setInitialBundleStartLevel(newlevel);
    }

    public void shutdownFramework() throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, 0L);
        try {
            bundle.stop();
        }
        catch (BundleException be) {
            IOException ioex = new IOException("Failed to shutdown framework");
            ioex.initCause(be);
            throw ioex;
        }
    }

    public void startBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        if (bundle != null) {
            try {
                bundle.start();
            }
            catch (BundleException be) {
                IOException ioex = new IOException("Failed to start bundle with id " + bundleIdentifier);
                ioex.initCause(be);
                throw ioex;
            }
        }
    }

    public CompositeData startBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            return new BatchActionResult("Failed to start bundles, bundle id's can't be null").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.startBundle(bundleIdentifiers[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    public void stopBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        if (bundle != null) {
            try {
                bundle.stop();
            }
            catch (BundleException e) {
                IOException ioex = new IOException("Failed to stop bundle with id " + bundleIdentifier);
                ioex.initCause(e);
                throw ioex;
            }
        }
    }

    public CompositeData stopBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            return new BatchActionResult("Failed to stop bundles, bundle id's can't be null").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.stopBundle(bundleIdentifiers[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    public void uninstallBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        if (bundle != null) {
            try {
                bundle.uninstall();
            }
            catch (BundleException be) {
                IOException ioex = new IOException("Failed to uninstall bundle with id " + bundleIdentifier);
                ioex.initCause(be);
                throw ioex;
            }
        }
    }

    public CompositeData uninstallBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            return new BatchActionResult("Failed uninstall bundles, bundle id's can't be null").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.uninstallBundle(bundleIdentifiers[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    public void updateBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        try {
            bundle.update();
        }
        catch (BundleException be) {
            IOException ioex = new IOException("Failed to update bundle with id " + bundleIdentifier);
            ioex.initCause(be);
            throw ioex;
        }
    }

    public void updateBundleFromURL(long bundleIdentifier, String url) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        InputStream inputStream = null;
        try {
            inputStream = this.createStream(url);
            bundle.update(inputStream);
        }
        catch (BundleException be) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            IOException ioex = new IOException("Can't update system bundle");
            ioex.initCause(be);
            throw ioex;
        }
    }

    public CompositeData updateBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            return new BatchActionResult("Failed to update bundles, bundle id's can't be null").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.updateBundle(bundleIdentifiers[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    public CompositeData updateBundlesFromURL(long[] bundleIdentifiers, String[] urls) throws IOException {
        if (bundleIdentifiers == null || urls == null) {
            return new BatchActionResult("Failed to update bundles arguments can't be null").toCompositeData();
        }
        if (bundleIdentifiers != null && urls != null && bundleIdentifiers.length != urls.length) {
            return new BatchActionResult("Failed to update bundles size of arguments should be same").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.updateBundleFromURL(bundleIdentifiers[i], urls[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    public void updateFramework() throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, 0L);
        try {
            bundle.update();
        }
        catch (BundleException be) {
            IOException ioex = new IOException("Failed to update system bundle");
            ioex.initCause(be);
            throw ioex;
        }
    }

    private CompositeData createFailedBatchActionResult(long[] bundleIdentifiers, int i, Throwable t) {
        long[] completed = new long[i];
        System.arraycopy(bundleIdentifiers, 0, completed, 0, i);
        long[] remaining = new long[bundleIdentifiers.length - i - 1];
        System.arraycopy(bundleIdentifiers, i + 1, remaining, 0, remaining.length);
        return new BatchActionResult(completed, t.toString(), remaining, bundleIdentifiers[i]).toCompositeData();
    }
}

