/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.registry;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.CompletableBindingRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.FieldGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.MethodGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.ParameterGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.TypeGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Elements;
import org.apache.felix.ipojo.manipulator.spi.AnnotationVisitorFactory;
import org.apache.felix.ipojo.manipulator.spi.BindingContext;
import org.apache.felix.ipojo.manipulator.spi.helper.Predicates;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

public class LegacyGenericBindingRegistry
extends CompletableBindingRegistry {
    public static final Pattern CUSTOM_HANDLER_PATTERN = Pattern.compile("(.*\\.ipojo\\..*)|(.*\\.handler\\..*)");

    public LegacyGenericBindingRegistry(BindingRegistry delegate, Reporter reporter) {
        super(delegate, reporter);
    }

    @Override
    protected List<Binding> createBindings(final Type type) {
        if (CUSTOM_HANDLER_PATTERN.matcher(type.getClassName()).matches()) {
            Binding binding = new Binding();
            binding.setAnnotationType(type);
            binding.setPredicate(Predicates.alwaysTrue());
            binding.setFactory(new AnnotationVisitorFactory(){

                @Override
                public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                    if (context.getClassNode() != null) {
                        return new TypeGenericVisitor(context.getWorkbench(), Elements.buildElement(type));
                    }
                    if (context.getFieldNode() != null) {
                        return new FieldGenericVisitor(context.getWorkbench(), Elements.buildElement(type), context.getFieldNode());
                    }
                    if (context.getMethodNode() != null && context.getParameterIndex() == -1) {
                        return new MethodGenericVisitor(context.getWorkbench(), Elements.buildElement(type), context.getMethodNode());
                    }
                    return new ParameterGenericVisitor(context.getWorkbench(), Elements.buildElement(type), context.getMethodNode(), context.getParameterIndex());
                }

                public String toString() {
                    return "LegacyGenericVisitorFactory";
                }
            });
            return Collections.singletonList(binding);
        }
        return Collections.emptyList();
    }
}

