/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handler.temporal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.FieldInterceptor;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.MethodInterceptor;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.handler.temporal.TemporalDependency;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class TemporalHandler
extends PrimitiveHandler
implements DependencyStateListener,
Pojo {
    private InstanceManager __IM;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int NO_POLICY = 0;
    public static final int NULLABLE = 1;
    public static final int DEFAULT_IMPLEMENTATION = 2;
    public static final int EMPTY = 3;
    public static final int NULL = 4;
    public static final String NAMESPACE = "org.apache.felix.ipojo.handler.temporal";
    private boolean __Fm_dependencies;
    private List m_dependencies;
    static /* synthetic */ Class class$java$util$Collection;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __Minvalidate$org_apache_felix_ipojo_util_DependencyModel;
    private boolean __Mvalidate$org_apache_felix_ipojo_util_DependencyModel;

    List __getm_dependencies() {
        if (!this.__Fm_dependencies) {
            return this.m_dependencies;
        }
        return (List)this.__IM.onGet((Object)this, "m_dependencies");
    }

    void __setm_dependencies(List list) {
        if (!this.__Fm_dependencies) {
            this.m_dependencies = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_dependencies", (Object)list);
    }

    public TemporalHandler() {
        this(null);
    }

    private TemporalHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_dependencies(new ArrayList(1));
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        for (int i = 0; i < this.__getm_dependencies().size(); ++i) {
            ((TemporalDependency)((Object)this.__getm_dependencies().get(i))).start();
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        for (int i = 0; i < this.__getm_dependencies().size(); ++i) {
            ((TemporalDependency)((Object)this.__getm_dependencies().get(i))).stop();
        }
        this.__getm_dependencies().clear();
    }

    public void configure(Element element, Dictionary dictionary) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__configure(element, dictionary);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{element, dictionary});
            this.__configure(element, dictionary);
            this.__IM.onExit((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __configure(Element meta, Dictionary dictionary) throws ConfigurationException {
        PojoMetadata manipulation = this.getFactory().getPojoMetadata();
        Element[] deps = meta.getElements("requires", NAMESPACE);
        for (int i = 0; i < deps.length; ++i) {
            boolean proxy;
            if (!deps[i].containsAttribute("field") || this.__getm_dependencies().contains(deps[i].getAttribute("field"))) {
                this.error("One temporal dependency must be attached to a field or the field is already used");
                return;
            }
            String field = deps[i].getAttribute("field");
            FieldMetadata fieldmeta = manipulation.getField(field);
            if (fieldmeta == null) {
                this.error("The field " + field + " does not exist in the class " + this.getInstanceManager().getClassName());
                return;
            }
            String fil = deps[i].getAttribute("filter");
            Filter filter = null;
            if (fil != null) {
                try {
                    filter = this.getInstanceManager().getContext().createFilter(fil);
                }
                catch (InvalidSyntaxException e) {
                    this.error("Cannot create the field from " + fil + ": " + e.getMessage());
                    return;
                }
            }
            boolean agg = false;
            boolean collection = false;
            String spec = fieldmeta.getFieldType();
            if (spec.endsWith("[]")) {
                agg = true;
                spec = spec.substring(0, spec.length() - 2);
            } else if ((class$java$util$Collection == null ? TemporalHandler.class$("java.util.Collection") : class$java$util$Collection).getName().equals(spec)) {
                agg = true;
                collection = true;
                spec = deps[i].getAttribute("specification");
                if (spec == null) {
                    this.error("A dependency injected inside a Collection must contain the 'specification' attribute");
                }
            }
            String prox = deps[i].getAttribute("proxy");
            boolean bl = proxy = prox != null && prox.equals("true");
            if (proxy && agg && !collection) {
                this.error("Proxied aggregate temporal dependencies cannot be an array. Only collections are supported");
            }
            long timeout = 3000L;
            if (deps[i].containsAttribute("timeout")) {
                String to = deps[i].getAttribute("timeout");
                timeout = to.equalsIgnoreCase("infinite") || to.equalsIgnoreCase("-1") ? Long.MAX_VALUE : new Long(deps[i].getAttribute("timeout"));
            }
            int policy = 0;
            String di = null;
            String onTimeout = deps[i].getAttribute("onTimeout");
            if (onTimeout != null) {
                if (onTimeout.equalsIgnoreCase("nullable")) {
                    policy = 1;
                } else if (onTimeout.equalsIgnoreCase("empty-array") || onTimeout.equalsIgnoreCase("empty")) {
                    policy = 3;
                    if (!agg) {
                        this.error("Cannot use the empty array policy for " + field + " : non aggregate dependency.");
                    }
                } else if (onTimeout.equalsIgnoreCase("null")) {
                    policy = 4;
                } else if (onTimeout.length() > 0) {
                    di = onTimeout;
                    policy = 2;
                }
            }
            Class specification = DependencyModel.loadSpecification((String)spec, (BundleContext)this.getInstanceManager().getContext());
            TemporalDependency dep = new TemporalDependency(specification, agg, collection, proxy, filter, this.getInstanceManager().getContext(), timeout, policy, di, this);
            this.__getm_dependencies().add(dep);
            if (!proxy) {
                MethodMetadata[] methods = manipulation.getMethods();
                for (int k = 0; k < methods.length; ++k) {
                    this.getInstanceManager().register(methods[k], (MethodInterceptor)dep);
                }
            }
            this.getInstanceManager().register(fieldmeta, (FieldInterceptor)dep);
        }
    }

    public void invalidate(DependencyModel dependencyModel) {
        if (!this.__Minvalidate$org_apache_felix_ipojo_util_DependencyModel) {
            this.__invalidate(dependencyModel);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", new Object[]{dependencyModel});
            this.__invalidate(dependencyModel);
            this.__IM.onExit((Object)this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", throwable);
            throw throwable;
        }
    }

    private void __invalidate(DependencyModel dependencymodel) {
    }

    public void validate(DependencyModel dependencyModel) {
        if (!this.__Mvalidate$org_apache_felix_ipojo_util_DependencyModel) {
            this.__validate(dependencyModel);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "validate$org_apache_felix_ipojo_util_DependencyModel", new Object[]{dependencyModel});
            this.__validate(dependencyModel);
            this.__IM.onExit((Object)this, "validate$org_apache_felix_ipojo_util_DependencyModel", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "validate$org_apache_felix_ipojo_util_DependencyModel", throwable);
            throw throwable;
        }
    }

    private void __validate(DependencyModel dependencymodel) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("m_dependencies")) {
            this.__Fm_dependencies = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("invalidate$org_apache_felix_ipojo_util_DependencyModel")) {
                this.__Minvalidate$org_apache_felix_ipojo_util_DependencyModel = true;
            }
            if (set.contains("validate$org_apache_felix_ipojo_util_DependencyModel")) {
                this.__Mvalidate$org_apache_felix_ipojo_util_DependencyModel = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

