/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.jaas.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.jaas.internal.BundleLoginModuleCreator;
import org.apache.felix.jaas.internal.ConfigLoginModuleProvider;
import org.apache.felix.jaas.internal.ConfigSpiOsgi;
import org.apache.felix.jaas.internal.ControlFlag;
import org.apache.felix.jaas.internal.LoginModuleProvider;
import org.apache.felix.jaas.internal.OsgiLoginModuleProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class JaasWebConsolePlugin
extends HttpServlet {
    private final ConfigSpiOsgi configSpi;
    private final BundleLoginModuleCreator loginModuleCreator;

    public JaasWebConsolePlugin(ConfigSpiOsgi configSpi, BundleLoginModuleCreator loginModuleCreator) {
        this.configSpi = configSpi;
        this.loginModuleCreator = loginModuleCreator;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getPathInfo().endsWith("/data.json")) {
            this.getJson(resp);
        } else {
            this.getHtml(resp);
        }
    }

    private void getHtml(HttpServletResponse resp) throws IOException {
        PrintWriter pw = resp.getWriter();
        this.printAppConfigurationDetails(pw);
        this.printAvailableModuleDetails(pw);
    }

    private void printAvailableModuleDetails(PrintWriter pw) {
        Map<Bundle, Set<String>> bundleMap = this.getAvailableLoginModuleInfo();
        pw.println("<p class=\"statline ui-state-highlight\">${Available LoginModules}</p>");
        if (bundleMap.isEmpty()) {
            return;
        }
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Bundle}</th>");
        pw.println("<th class=\"header\">${Classes}</th>");
        pw.println("</tr></thead>");
        String rowClass = "odd";
        for (Map.Entry<Bundle, Set<String>> e : bundleMap.entrySet()) {
            Bundle b = e.getKey();
            pw.print("<tr class=\"%s ui-state-default\">");
            pw.printf("<td><a href=\"${pluginRoot}/../bundles/%s\">%s (%s)</a></td>", b.getBundleId(), b.getSymbolicName(), b.getBundleId());
            pw.printf("<td>", new Object[0]);
            for (String className : e.getValue()) {
                pw.print(className);
                pw.print("<br/>");
            }
            pw.print("</td>");
            pw.println("</tr>");
            if (rowClass.equals("odd")) {
                rowClass = "even";
                continue;
            }
            rowClass = "odd";
        }
        pw.println("</table>");
    }

    private void printAppConfigurationDetails(PrintWriter pw) {
        Map<String, ConfigSpiOsgi.Realm> configs = this.getConfigurationDetails();
        if (configs.isEmpty()) {
            pw.println("No JAAS LoginModule registered");
            return;
        }
        pw.println("<p class=\"statline ui-state-highlight\">${Registered LoginModules}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Realm}</th>");
        pw.println("<th class=\"header\">${Rank}</th>");
        pw.println("<th class=\"header\">${Control Flag}</th>");
        pw.println("<th class=\"header\">${Type}</th>");
        pw.println("<th class=\"header\">${Classname}</th>");
        pw.println("</tr></thead>");
        for (ConfigSpiOsgi.Realm r : configs.values()) {
            String realmName = r.getRealmName();
            pw.printf("<tr class=\"ui-state-default\"><td>%s</td><td colspan=\"4\"></td></tr>", realmName);
            String rowClass = "odd";
            for (ConfigSpiOsgi.AppConfigurationHolder ah : r.getConfigs()) {
                Object id;
                LoginModuleProvider lp = ah.getProvider();
                String type = this.getType(lp);
                pw.printf("<tr class=\"%s ui-state-default\"><td></td><td>%d</td>", rowClass, lp.ranking());
                pw.printf("<td>%s</td>", ControlFlag.toString(lp.getControlFlag()));
                pw.printf("<td>%s</td>", type);
                pw.printf("<td>", new Object[0]);
                pw.print(lp.getClassName());
                if (lp instanceof OsgiLoginModuleProvider) {
                    ServiceReference sr = ((OsgiLoginModuleProvider)lp).getServiceReference();
                    id = sr.getProperty("service.id");
                    pw.printf("<a href=\"${pluginRoot}/../services/%s\">(%s)</a>", id, id);
                } else if (lp instanceof ConfigLoginModuleProvider) {
                    Map<String, ?> config = lp.options();
                    id = config.get("service.pid");
                    pw.printf("<a href=\"${pluginRoot}/../configMgr/%s\">(Details)</a>", id);
                }
                pw.printf("</td>", new Object[0]);
                pw.println("</tr>");
                if (rowClass.equals("odd")) {
                    rowClass = "even";
                    continue;
                }
                rowClass = "odd";
            }
        }
        pw.println("</table>");
    }

    private String getType(LoginModuleProvider lp) {
        String type = "Service";
        if (lp instanceof ConfigLoginModuleProvider) {
            type = "Configuration";
        }
        return type;
    }

    private void getJson(HttpServletResponse resp) {
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("JAAS Configuration Details:");
        pw.println();
        pw.println("Registered LoginModules");
        Map<String, ConfigSpiOsgi.Realm> configs = this.getConfigurationDetails();
        if (configs.isEmpty()) {
            pw.println("No JAAS LoginModule registered");
        } else {
            for (ConfigSpiOsgi.Realm r : configs.values()) {
                String realmName = r.getRealmName();
                pw.printf("Realm : %s \n", realmName);
                for (ConfigSpiOsgi.AppConfigurationHolder ah : r.getConfigs()) {
                    JaasWebConsolePlugin.addSpace(pw, 1);
                    pw.printf("%s \n", ah.getProvider().getClassName());
                    JaasWebConsolePlugin.addSpace(pw, 2);
                    pw.printf("Flag    : %s \n", ControlFlag.toString(ah.getProvider().getControlFlag()));
                    JaasWebConsolePlugin.addSpace(pw, 2);
                    pw.printf("Type    : %s \n", this.getType(ah.getProvider()));
                    JaasWebConsolePlugin.addSpace(pw, 2);
                    pw.printf("Ranking : %d \n", ah.getProvider().ranking());
                }
            }
        }
        pw.println();
        Map<Bundle, Set<String>> bundleMap = this.getAvailableLoginModuleInfo();
        pw.println("Available LoginModules");
        if (!bundleMap.isEmpty()) {
            for (Map.Entry<Bundle, Set<String>> e : bundleMap.entrySet()) {
                Bundle b = e.getKey();
                pw.printf("%s (%s) \n", b.getSymbolicName(), b.getBundleId());
                for (String className : e.getValue()) {
                    JaasWebConsolePlugin.addSpace(pw, 1);
                    pw.println(className);
                }
            }
        }
    }

    private static void addSpace(PrintWriter pw, int count) {
        for (int i = 0; i < count; ++i) {
            pw.print("  ");
        }
    }

    private Map<String, ConfigSpiOsgi.Realm> getConfigurationDetails() {
        return this.configSpi.getAllConfiguration();
    }

    private Map<Bundle, Set<String>> getAvailableLoginModuleInfo() {
        return this.loginModuleCreator.getBundleToLoginModuleMapping();
    }
}

