/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.importer.core.upnp;

import java.util.Hashtable;
import org.apache.felix.upnp.basedriver.Activator;
import org.apache.felix.upnp.basedriver.util.Converter;
import org.cybergarage.upnp.AllowedValueList;
import org.cybergarage.upnp.AllowedValueRange;
import org.cybergarage.upnp.StateVariable;
import org.osgi.service.upnp.UPnPStateVariable;

public class UPnPStateVariableImpl
implements UPnPStateVariable {
    private StateVariable variable;
    private Number max = null;
    private Number min = null;
    private Number step = null;
    private String[] values = null;
    private Boolean hasMaxMinStep = null;
    private Boolean hasRangeValues = null;
    private static Hashtable upnp2javaTable;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Number;

    public UPnPStateVariableImpl(StateVariable variable) {
        this.variable = variable;
    }

    public String getName() {
        return this.variable.getName();
    }

    public Class getJavaDataType() {
        return (Class)upnp2javaTable.get(this.variable.getDataType());
    }

    public String getUPnPDataType() {
        return this.variable.getDataType();
    }

    public Object getDefaultValue() {
        return null;
    }

    public String[] getAllowedValues() {
        if (this.hasRangeValues == null) {
            this.initValueConstraint();
        }
        return this.values;
    }

    public Number getMinimum() {
        if (this.hasMaxMinStep == null) {
            this.initValueConstraint();
        }
        return this.min;
    }

    public Number getMaximum() {
        if (this.hasMaxMinStep == null) {
            this.initValueConstraint();
        }
        return this.max;
    }

    private void initValueConstraint() {
        if (this.hasRangeValues != null || this.hasMaxMinStep != null) {
            return;
        }
        this.hasRangeValues = Boolean.FALSE;
        this.hasMaxMinStep = Boolean.FALSE;
        AllowedValueRange allowedValueRange = this.variable.getAllowedValueRange();
        AllowedValueList allowedValueList = this.variable.getAllowedValueList();
        if (allowedValueRange != null && allowedValueList != null) {
            Activator.logger.WARNING("Imported device with StateVariable " + this.variable.getName() + " contains either AllowedValueRange and AllowedValueList UPnP doesn't allow it because it. Neither of the restriction will be applied");
        } else if (allowedValueRange != null) {
            this.initMaxMinStep(allowedValueRange);
        } else if (allowedValueList != null) {
            this.initAllowedValues(allowedValueList);
        }
    }

    private void initAllowedValues(AllowedValueList allowedValueList) {
        if ((class$java$lang$String == null ? (class$java$lang$String = UPnPStateVariableImpl.class$("java.lang.String")) : class$java$lang$String) != this.getJavaDataType()) {
            Activator.logger.WARNING("Imported device with StateVariable " + this.variable.getName() + " contains AllowedValueList but its UPnP type doesn't allow it because it is +" + this.getUPnPDataType());
            return;
        }
        if (allowedValueList.size() == 0) {
            return;
        }
        this.values = new String[allowedValueList.size()];
        for (int i = 0; i < allowedValueList.size(); ++i) {
            this.values[i] = allowedValueList.getAllowedValue(i).getValue();
        }
    }

    private void initMaxMinStep(AllowedValueRange allowedValueRange) {
        if (allowedValueRange == null) {
            return;
        }
        if (!(class$java$lang$Number == null ? (class$java$lang$Number = UPnPStateVariableImpl.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.getJavaDataType())) {
            Activator.logger.WARNING("Imported device with StateVariable " + this.variable.getName() + " contains AllowedValueRange but its UPnP type doesn't allow it because it is +" + this.getUPnPDataType());
            return;
        }
        String maxStr = allowedValueRange.getMaximum();
        String minStr = allowedValueRange.getMinimum();
        String stepStr = allowedValueRange.getStep();
        try {
            String type = this.getUPnPDataType();
            this.max = (Number)Converter.parseString(maxStr, type);
            this.min = (Number)Converter.parseString(minStr, type);
            this.step = (Number)Converter.parseString(stepStr, type);
        }
        catch (Exception ex) {
            Activator.logger.WARNING("Imported device with StateVariable " + this.variable.getName() + " contains an invalid definition for AllowedValueRange");
        }
        this.hasMaxMinStep = Boolean.TRUE;
    }

    public Number getStep() {
        if (this.hasMaxMinStep == null) {
            this.initValueConstraint();
        }
        return this.step;
    }

    public boolean sendsEvents() {
        return this.variable.isSendEvents();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i;
        upnp2javaTable = null;
        upnp2javaTable = new Hashtable(30);
        String[] upnpType = null;
        upnpType = new String[]{"ui1", "ui2", "i1", "i2", "i4", "int"};
        for (i = 0; i < upnpType.length; ++i) {
            upnp2javaTable.put(upnpType[i], class$java$lang$Integer == null ? UPnPStateVariableImpl.class$("java.lang.Integer") : class$java$lang$Integer);
        }
        upnpType = new String[]{"ui4", "time", "time.tz"};
        for (i = 0; i < upnpType.length; ++i) {
            upnp2javaTable.put(upnpType[i], class$java$lang$Long == null ? UPnPStateVariableImpl.class$("java.lang.Long") : class$java$lang$Long);
        }
        upnpType = new String[]{"r4", "float"};
        for (i = 0; i < upnpType.length; ++i) {
            upnp2javaTable.put(upnpType[i], class$java$lang$Float == null ? UPnPStateVariableImpl.class$("java.lang.Float") : class$java$lang$Float);
        }
        upnpType = new String[]{"r8", "number", "fixed.14.4"};
        for (i = 0; i < upnpType.length; ++i) {
            upnp2javaTable.put(upnpType[i], class$java$lang$Double == null ? UPnPStateVariableImpl.class$("java.lang.Double") : class$java$lang$Double);
        }
        upnpType = new String[]{"char"};
        for (i = 0; i < upnpType.length; ++i) {
            upnp2javaTable.put(upnpType[i], class$java$lang$Character == null ? UPnPStateVariableImpl.class$("java.lang.Character") : class$java$lang$Character);
        }
        upnpType = new String[]{"string", "uri", "uuid"};
        for (i = 0; i < upnpType.length; ++i) {
            upnp2javaTable.put(upnpType[i], class$java$lang$String == null ? UPnPStateVariableImpl.class$("java.lang.String") : class$java$lang$String);
        }
        upnpType = new String[]{"date", "dateTime", "dateTime.tz"};
        for (i = 0; i < upnpType.length; ++i) {
            upnp2javaTable.put(upnpType[i], class$java$util$Date == null ? UPnPStateVariableImpl.class$("java.util.Date") : class$java$util$Date);
        }
        upnpType = new String[]{"boolean"};
        for (i = 0; i < upnpType.length; ++i) {
            upnp2javaTable.put(upnpType[i], class$java$lang$Boolean == null ? UPnPStateVariableImpl.class$("java.lang.Boolean") : class$java$lang$Boolean);
        }
        upnpType = new String[]{"bin.base64", "bin.hex"};
        for (i = 0; i < upnpType.length; ++i) {
            upnp2javaTable.put(upnpType[i], array$B == null ? UPnPStateVariableImpl.class$("[B") : array$B);
        }
    }
}

