/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.maven.osgicheck.impl.mddocgen;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.felix.maven.osgicheck.impl.mddocgen.AbstractMarkdownMojo;
import org.apache.felix.maven.osgicheck.impl.mddocgen.ClassName;
import org.apache.felix.maven.osgicheck.impl.mddocgen.MavenScrLogger;
import org.apache.felix.maven.osgicheck.impl.mddocgen.SyntheticBundle;
import org.apache.felix.scr.impl.helper.Logger;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.Faker;
import org.apache.felix.scr.impl.metadata.PropertyMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.apache.felix.scr.impl.parser.KXml2SAXHandler;
import org.apache.felix.scr.impl.parser.KXml2SAXParser;
import org.apache.felix.scr.impl.xml.XmlHandler;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.IOUtil;
import org.osgi.framework.Bundle;

@Mojo(name="generate-services-doc", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=false)
public final class ServicesMarkdownGeneratorMojo
extends AbstractMarkdownMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File servicesDirectory;
    @Parameter(defaultValue="${project.build.directory}/mddoc/services/${project.artifactId}/${project.version}")
    private File servicesMarkdownDirectory;
    @Parameter(defaultValue="${project.name} ${project.version} Services", readonly=true)
    private String readmeTitle;
    private final MavenScrLogger mavenScrLogger = new MavenScrLogger(this.getLog());

    @Override
    protected String getReadmeTitle() {
        return this.readmeTitle;
    }

    @Override
    protected File getSourceDir() {
        return this.servicesDirectory;
    }

    @Override
    protected File getTargetDir() {
        return this.servicesMarkdownDirectory;
    }

    @Override
    protected String getIncludes() {
        return "**/OSGI-INF/*.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(Collection<File> services) {
        for (File serviceFile : services) {
            List<ComponentMetadata> metadata = this.readComponentMetadata(serviceFile);
            for (ComponentMetadata component : metadata) {
                String[] providedServices;
                ServiceMetadata serviceMetadata;
                if (this.isExcluded(component.getImplementationClassName()) || (serviceMetadata = component.getServiceMetadata()) == null || (providedServices = serviceMetadata.getProvides()) == null || providedServices.length <= 0) continue;
                ClassName className = ClassName.get(component.getImplementationClassName());
                for (String providedService : providedServices) {
                    this.doIndex(providedService, className);
                }
                File targetDir = new File(this.servicesMarkdownDirectory, className.getPackagePath());
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                File targetFile = new File(targetDir, className.getSimpleName() + ".md");
                PrintWriter writer = null;
                try {
                    writer = ServicesMarkdownGeneratorMojo.newPrintWriter(targetFile);
                    writer.format("# %s%n%n", component.getName());
                    List<PropertyMetadata> properties = Faker.getPropertyMetaData(component);
                    if (properties.isEmpty()) continue;
                    writer.println("# Properties");
                    writer.println();
                    writer.println("| Name | Type | Value |");
                    writer.println("| ---- | ---- | ----- |");
                    for (PropertyMetadata property : properties) {
                        writer.format("| %s | %s | %s |%n", property.getName(), property.getType() != null ? property.getType() : "String", property.getValue().getClass().isArray() ? Arrays.toString((Object[])property.getValue()) : property.getValue());
                    }
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("An error occurred while rendering documentation in " + targetFile), (Throwable)e);
                }
                finally {
                    IOUtil.close((Writer)writer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ComponentMetadata> readComponentMetadata(File serviceFile) {
        this.getLog().debug((CharSequence)("Analyzing '" + serviceFile + "' SCR file..."));
        FileReader reader = null;
        List metadata = null;
        try {
            reader = new FileReader(serviceFile);
            XmlHandler xmlHandler = new XmlHandler((Bundle)new SyntheticBundle(this.servicesDirectory, serviceFile), (Logger)this.mavenScrLogger, false, true);
            KXml2SAXParser parser = new KXml2SAXParser((Reader)reader);
            parser.parseXML((KXml2SAXHandler)xmlHandler);
            this.getLog().debug((CharSequence)("SCR file '" + serviceFile + "' successfully load"));
            metadata = xmlHandler.getComponentMetadataList();
        }
        catch (Exception e) {
            try {
                this.getLog().error((CharSequence)("SCR file '" + serviceFile + "' could not be read"), (Throwable)e);
                metadata = Collections.emptyList();
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
            IOUtil.close((Reader)reader);
        }
        IOUtil.close((Reader)reader);
        return metadata;
    }
}

