/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.analyzer;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.dom.AnalyzerAdapter;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.OperationNode;
import flex2.compiler.mxml.dom.RequestNode;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;

public class WebServiceAnalyzer
extends AnalyzerAdapter {
    private MxmlDocument document;

    public WebServiceAnalyzer(CompilationUnit unit, MxmlConfiguration mxmlConfiguration, MxmlDocument document) {
        super(unit, mxmlConfiguration);
        this.document = document;
    }

    public void analyze(OperationNode node) {
        if (node.getAttributeValue("name") == null) {
            this.log(node, (CompilerMessage)new OperationRequiresName());
        }
        super.analyze(node);
    }

    public void analyze(RequestNode node) {
        int attrCount = node.getAttributeCount();
        if (attrCount > 1 || attrCount == 1 && !node.getAttributeNames().next().getLocalPart().equals("format")) {
            this.log(node, (CompilerMessage)new RequestRequiresFormat());
        }
        super.analyze(node);
    }

    public void analyze(Node node) {
        super.analyze(node);
    }

    protected int getDocumentVersion() {
        return this.document.getVersion();
    }

    protected String getLanguageNamespace() {
        return this.document.getLanguageNamespace();
    }

    public static class RequestRequiresFormat
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2836590913630566556L;
    }

    public static class OperationRequiresName
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2365576843611189649L;
    }
}

