/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flex2.compiler.mxml.reflect.Event;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.LineNumberMapped;
import flex2.compiler.mxml.rep.Model;

public class EventHandler
implements LineNumberMapped {
    private Model model;
    private Event event;
    private String eventHandlerText;
    private String documentFunctionName;
    private String state;
    private int xmlLineNumber;

    public EventHandler(Model model, Event event, String eventHandlerText) {
        this.model = model;
        this.event = event;
        this.eventHandlerText = eventHandlerText;
    }

    public EventHandler(Model model, Event event, String eventHandlerText, String state) {
        this.model = model;
        this.event = event;
        this.eventHandlerText = eventHandlerText;
        this.state = state;
    }

    public Model getModel() {
        return this.model;
    }

    public String getName() {
        return this.event.getName();
    }

    public Type getType() {
        return this.event.getType();
    }

    public String getEventHandlerText() {
        return this.eventHandlerText;
    }

    public String getDocumentFunctionName() {
        if (this.documentFunctionName == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("__");
            this.buildNameChain(buf, this.model);
            buf.append("_");
            buf.append(this.event.getName());
            buf.append(this.state != null ? "_" + this.state : "");
            this.documentFunctionName = buf.toString();
        }
        return this.documentFunctionName;
    }

    private boolean buildNameChain(StringBuilder buf, Model mod) {
        if (mod != null) {
            if (mod.getId() != null) {
                buf.append(mod.getId());
            } else {
                boolean needSep = this.buildNameChain(buf, mod.getParent());
                if (needSep) {
                    buf.append("_");
                }
                assert (mod.getParentIndex() != null);
                buf.append(mod.getParentIndex());
            }
            return true;
        }
        return false;
    }

    public int getXmlLineNumber() {
        return this.xmlLineNumber;
    }

    public void setXmlLineNumber(int xmlLineNumber) {
        this.xmlLineNumber = xmlLineNumber;
    }
}

