/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.as.codegen;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.flex.abc.instructionlist.InstructionList;
import org.apache.flex.abc.semantics.Label;
import org.apache.flex.abc.semantics.MethodBodyInfo;
import org.apache.flex.abc.semantics.MethodInfo;
import org.apache.flex.abc.semantics.Name;
import org.apache.flex.abc.semantics.Namespace;
import org.apache.flex.abc.semantics.Nsset;
import org.apache.flex.abc.visitors.IABCVisitor;
import org.apache.flex.abc.visitors.IMethodBodyVisitor;
import org.apache.flex.abc.visitors.IMethodVisitor;
import org.apache.flex.abc.visitors.ITraitVisitor;
import org.apache.flex.abc.visitors.ITraitsVisitor;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.common.IMetaInfo;
import org.apache.flex.compiler.constants.IASLanguageConstants;
import org.apache.flex.compiler.css.ICSSDocument;
import org.apache.flex.compiler.definitions.IAppliedVectorDefinition;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.IVariableDefinition;
import org.apache.flex.compiler.definitions.references.IReference;
import org.apache.flex.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.flex.compiler.definitions.references.ReferenceFactory;
import org.apache.flex.compiler.exceptions.CodegenInterruptedException;
import org.apache.flex.compiler.internal.abc.FunctionGeneratorHelper;
import org.apache.flex.compiler.internal.as.codegen.ABCGeneratingReducer;
import org.apache.flex.compiler.internal.as.codegen.Binding;
import org.apache.flex.compiler.internal.as.codegen.ClassDirectiveProcessor;
import org.apache.flex.compiler.internal.as.codegen.LexicalScope;
import org.apache.flex.compiler.internal.caches.CSSDocumentCache;
import org.apache.flex.compiler.internal.codegen.databinding.BindingInfo;
import org.apache.flex.compiler.internal.codegen.databinding.MXMLBindingDirectiveHelper;
import org.apache.flex.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.flex.compiler.internal.css.codegen.CSSEmitter;
import org.apache.flex.compiler.internal.css.codegen.CSSReducer;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.definitions.DefinitionBase;
import org.apache.flex.compiler.internal.definitions.EventDefinition;
import org.apache.flex.compiler.internal.definitions.FunctionDefinition;
import org.apache.flex.compiler.internal.definitions.NamespaceDefinition;
import org.apache.flex.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.resourcebundles.ResourceBundleUtils;
import org.apache.flex.compiler.internal.scopes.ASProjectScope;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.internal.semantics.SemanticUtils;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.as.VariableNode;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.mxml.IMXMLTypeConstants;
import org.apache.flex.compiler.problems.CSSCodeGenProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.MXMLExecutableStatementsInScriptBlockProblem;
import org.apache.flex.compiler.problems.MXMLOuterDocumentAlreadyDeclaredProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.scopes.IASScope;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IScopedNode;
import org.apache.flex.compiler.tree.mxml.IMXMLArrayNode;
import org.apache.flex.compiler.tree.mxml.IMXMLBindingNode;
import org.apache.flex.compiler.tree.mxml.IMXMLBooleanNode;
import org.apache.flex.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.flex.compiler.tree.mxml.IMXMLClassNode;
import org.apache.flex.compiler.tree.mxml.IMXMLClassReferenceNode;
import org.apache.flex.compiler.tree.mxml.IMXMLClearNode;
import org.apache.flex.compiler.tree.mxml.IMXMLComponentNode;
import org.apache.flex.compiler.tree.mxml.IMXMLConcatenatedDataBindingNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDataBindingNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDeclarationsNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDeferredInstanceNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDefinitionNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDesignLayerNode;
import org.apache.flex.compiler.tree.mxml.IMXMLEffectSpecifierNode;
import org.apache.flex.compiler.tree.mxml.IMXMLEmbedNode;
import org.apache.flex.compiler.tree.mxml.IMXMLEventSpecifierNode;
import org.apache.flex.compiler.tree.mxml.IMXMLExpressionNode;
import org.apache.flex.compiler.tree.mxml.IMXMLFactoryNode;
import org.apache.flex.compiler.tree.mxml.IMXMLFunctionNode;
import org.apache.flex.compiler.tree.mxml.IMXMLImplementsNode;
import org.apache.flex.compiler.tree.mxml.IMXMLInstanceNode;
import org.apache.flex.compiler.tree.mxml.IMXMLIntNode;
import org.apache.flex.compiler.tree.mxml.IMXMLLibraryNode;
import org.apache.flex.compiler.tree.mxml.IMXMLMetadataNode;
import org.apache.flex.compiler.tree.mxml.IMXMLModelNode;
import org.apache.flex.compiler.tree.mxml.IMXMLModelPropertyContainerNode;
import org.apache.flex.compiler.tree.mxml.IMXMLModelPropertyNode;
import org.apache.flex.compiler.tree.mxml.IMXMLModelRootNode;
import org.apache.flex.compiler.tree.mxml.IMXMLNode;
import org.apache.flex.compiler.tree.mxml.IMXMLNumberNode;
import org.apache.flex.compiler.tree.mxml.IMXMLObjectNode;
import org.apache.flex.compiler.tree.mxml.IMXMLPrivateNode;
import org.apache.flex.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.flex.compiler.tree.mxml.IMXMLRegExpNode;
import org.apache.flex.compiler.tree.mxml.IMXMLRemoteObjectMethodNode;
import org.apache.flex.compiler.tree.mxml.IMXMLReparentNode;
import org.apache.flex.compiler.tree.mxml.IMXMLRepeaterNode;
import org.apache.flex.compiler.tree.mxml.IMXMLResourceNode;
import org.apache.flex.compiler.tree.mxml.IMXMLScriptNode;
import org.apache.flex.compiler.tree.mxml.IMXMLSingleDataBindingNode;
import org.apache.flex.compiler.tree.mxml.IMXMLSpecifierNode;
import org.apache.flex.compiler.tree.mxml.IMXMLStateNode;
import org.apache.flex.compiler.tree.mxml.IMXMLStringNode;
import org.apache.flex.compiler.tree.mxml.IMXMLStyleNode;
import org.apache.flex.compiler.tree.mxml.IMXMLStyleSpecifierNode;
import org.apache.flex.compiler.tree.mxml.IMXMLUintNode;
import org.apache.flex.compiler.tree.mxml.IMXMLVectorNode;
import org.apache.flex.compiler.tree.mxml.IMXMLWebServiceOperationNode;
import org.apache.flex.compiler.tree.mxml.IMXMLXMLListNode;
import org.apache.flex.compiler.tree.mxml.IMXMLXMLNode;
import org.apache.flex.compiler.units.ICompilationUnit;

public class MXMLClassDirectiveProcessor
extends ClassDirectiveProcessor {
    private static final Namespace MXML_PRIVATE_NAMESPACE = new Namespace(5, "MXMLPrivateNS");
    private static final Nsset MXML_PRIVATE_NAMESPACE_SET = new Nsset(MXML_PRIVATE_NAMESPACE);
    private static final String EVENT_HANDLER_NAME_BASE = ">";
    private static final String VECTOR_GENERATOR_NAME_BASE = ">v";
    private static final String INSTANCE_INITIALIZER_NAME_BASE = "i";
    private static final String BINDABLE_OVERRIDE_NAME_BASE = "_bo";
    private static final Object[] CONSTRUCT_XML_LIST_OPERANDS = new Object[]{ABCGeneratingReducer.xmlListType, 1};
    private static Name NAME_DOCUMENT_DESCRIPTOR = MXMLClassDirectiveProcessor.createMXMLPrivateName("dd");
    private static Name NAME_MODULE_FACTORY_INITIALIZED = MXMLClassDirectiveProcessor.createMXMLPrivateName("mfi");
    private static Name NAME_MXML_DESCRIPTOR = MXMLClassDirectiveProcessor.createMXMLPrivateName("mxmldd");
    private static Name NAME_MXML_DESCRIPTOR_GETTER = new Name("MXMLDescriptor");
    private static Name NAME_MXML_PROPERTIES = MXMLClassDirectiveProcessor.createMXMLPrivateName("mxmldp");
    private static Name NAME_MXML_STATE_DESCRIPTOR = new Name("mxmlsd");
    private static Name NAME_GENERATE_CSSSTYLEDECLARATIONS = new Name("generateCSSStyleDeclarations");
    private final IMXMLClassDefinitionNode classDefinitionNode;
    protected final LexicalScope globalScope;
    private int numElements = 0;
    private int instanceInitializerCounter = 0;
    private int bindableOverrideCounter = 0;
    private int eventHandlerCounter = 0;
    private int vectorGeneratorCounter = 0;
    private final MXMLBindingDirectiveHelper bindingDirectiveHelper = new MXMLBindingDirectiveHelper(this, this.emitter);
    private final InstructionList iinitAfterSuperInsns = new InstructionList();
    private final InstructionList iinitForNonPublicProperties = new InstructionList();
    private final InstructionList mxmlPropertiesInsns = new InstructionList();
    private final Map<IMXMLInstanceNode, Name> instanceInitializerMap = new HashMap<IMXMLInstanceNode, Name>();
    private final Map<IMXMLEventSpecifierNode, Name> eventHandlerMap = new HashMap<IMXMLEventSpecifierNode, Name>();
    private final Map<Name, Name> VectorGeneratorMap = new HashMap<Name, Name>();
    private boolean hasStyleSpecifiers = false;
    private boolean hasEffectSpecifiers = false;
    private int styleTagIndex = 0;
    protected Map<IMXMLNode, Integer> nodeToIndexMap;
    protected Map<IMXMLNode, InstructionList> nodeToInstanceDescriptorMap;
    protected Map<Integer, IMXMLNode> indexToNodeMap;
    private static final Predicate<IASNode> MXML_INSTANCE_NODES = new Predicate<IASNode>(){

        public boolean apply(IASNode node) {
            return node instanceof IMXMLInstanceNode;
        }
    };
    private static final Predicate<IASNode> MXML_SPECIFIER_NODES = new Predicate<IASNode>(){

        public boolean apply(IASNode node) {
            return node instanceof IMXMLSpecifierNode;
        }
    };

    private static Name createMXMLPrivateName(String baseName) {
        return new Name(7, MXML_PRIVATE_NAMESPACE_SET, baseName);
    }

    public static MethodInfo createEventHandlerMethodInfo(ICompilerProject project, IMXMLEventSpecifierNode eventNode, String handlerName) {
        MethodInfo mi = new MethodInfo();
        mi.setMethodName(handlerName);
        EventDefinition eventDefinition = (EventDefinition)eventNode.getDefinition();
        Name eventTypeName = eventDefinition.getTypeReference().getMName(project, (ASScope)eventDefinition.getContainingScope());
        Vector<Name> paramTypes = new Vector<Name>();
        paramTypes.add(eventTypeName);
        mi.setParamTypes(paramTypes);
        Vector<String> paramName = new Vector<String>();
        paramName.add("event");
        mi.setParamNames(paramName);
        mi.setFlags(mi.getFlags() | 2);
        mi.setReturnType(IMXMLTypeConstants.NAME_VOID);
        return mi;
    }

    public static MethodInfo createVectorGeneratorMethodInfo(ICompilerProject project, IMXMLVectorNode vectorNode, String handlerName) {
        MethodInfo mi = new MethodInfo();
        mi.setMethodName(handlerName);
        ITypeDefinition type = vectorNode.getType();
        Name typeName = ((TypeDefinitionBase)type).getMName(project);
        Vector<Name> paramTypes = new Vector<Name>();
        paramTypes.add(IMXMLTypeConstants.NAME_ARRAY);
        mi.setParamTypes(paramTypes);
        Vector<String> paramName = new Vector<String>();
        paramName.add("array");
        mi.setParamNames(paramName);
        mi.setFlags(mi.getFlags() | 2);
        mi.setReturnType(typeName);
        return mi;
    }

    private static MethodInfo createInstanceInitializerMethodInfo(String name, Name type) {
        MethodInfo mi = new MethodInfo();
        mi.setMethodName(name);
        mi.setReturnType(type);
        return mi;
    }

    MXMLClassDirectiveProcessor(IMXMLClassDefinitionNode classDefinitionNode, LexicalScope enclosingScope, IABCVisitor emitter) {
        super(classDefinitionNode, (ClassDefinition)classDefinitionNode.getClassDefinition(), enclosingScope, emitter);
        this.classDefinitionNode = classDefinitionNode;
        this.globalScope = enclosingScope;
    }

    void processMainClassDefinitionNode(IMXMLClassDefinitionNode node) {
        Context context = new Context(this.classDefinitionNode, this.iinitAfterSuperInsns);
        this.setupDeferredInstancesForStateDependentInstances(context);
        this.traverse(node, context);
        if (!this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            this.setDocumentDescriptorForClass(node, context);
        } else {
            this.addVariableTrait(NAME_MXML_DESCRIPTOR, IMXMLTypeConstants.NAME_ARRAY);
            this.addVariableTrait(NAME_MXML_PROPERTIES, IMXMLTypeConstants.NAME_ARRAY);
            this.addVariableTrait(NAME_MXML_STATE_DESCRIPTOR, IMXMLTypeConstants.NAME_ARRAY);
        }
        this.setDocument(node, false, context);
        this.numElements = this.setSpecifiers(context, this.getProject().getTargetSettings().getMxmlChildrenAsData(), true);
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            this.overrideMXMLDescriptorGetter(node, context);
            if (this.numElements > 0) {
                this.overrideMXMLPropertiesGetter(node, context, this.numElements);
            }
        }
        this.generateBindableImpl();
        this.generateRequiredContingentDefinitions();
        this.generateStylesAndEffects(context);
    }

    private void setupDeferredInstancesForStateDependentInstances(Context context) {
        List<IMXMLNode> stateDependentNodes = this.classDefinitionNode.getAllStateDependentNodes();
        if (stateDependentNodes == null) {
            return;
        }
        FlexProject project = this.getProject();
        String deferredInstanceFromFunctionClass = project.getDeferredInstanceFromFunctionClass();
        Name deferredInstanceFromFunctionName = project.getDeferredInstanceFromFunctionName();
        if (!project.getTargetSettings().getMxmlChildrenAsData() && !this.classDefinition.isInstanceOf("mx.core.IStateClient2", (ICompilerProject)project)) {
            IResolvedQualifiersReference stateClient2Reference = ReferenceFactory.packageQualifiedReference(this.getProject().getWorkspace(), "mx.core.IStateClient2");
            Name stateClient2Name = stateClient2Reference.getMName();
            IReference[] implementedInterfaces = this.classDefinition.getImplementedInterfaceReferences();
            IReference[] newInterfaces = null;
            Name[] newNames = null;
            if (implementedInterfaces != null) {
                int n = implementedInterfaces.length;
                newInterfaces = new IReference[n + 1];
                newNames = new Name[n + 1];
                for (int i = 0; i < n; ++i) {
                    newInterfaces[i] = implementedInterfaces[i];
                    newNames[i] = this.iinfo.interfaceNames[i];
                }
                newInterfaces[n] = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "mx.core.IStateClient2");
                newNames[n] = stateClient2Name;
            } else {
                newInterfaces = new IReference[]{ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "mx.core.IStateClient2")};
                newNames = new Name[]{stateClient2Name};
            }
            this.classDefinition.setImplementedInterfaceReferences(newInterfaces);
            this.iinfo.interfaceNames = newNames;
        }
        int instanceNodeCounter = 0;
        IMXMLNode anInstanceNode = null;
        for (IMXMLNode node : stateDependentNodes) {
            if (!(node instanceof IMXMLInstanceNode)) continue;
            anInstanceNode = node;
            if (this.nodeToIndexMap == null) {
                this.nodeToIndexMap = new HashMap<IMXMLNode, Integer>();
                this.indexToNodeMap = new HashMap<Integer, IMXMLNode>();
            }
            this.nodeToIndexMap.put(node, instanceNodeCounter);
            this.indexToNodeMap.put(instanceNodeCounter, node);
            ++instanceNodeCounter;
            if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                if (this.nodeToInstanceDescriptorMap == null) {
                    this.nodeToInstanceDescriptorMap = new HashMap<IMXMLNode, InstructionList>();
                }
                InstructionList il = new InstructionList();
                this.nodeToInstanceDescriptorMap.put(node, il);
                Context stateContext = new Context((IMXMLInstanceNode)node, il);
                stateContext.isContentFactory = true;
                this.processNode(node, stateContext);
                stateContext.transfer(IL.MXML_CONTENT_FACTORY);
                stateContext.addInstruction(86, stateContext.getCounter(IL.MXML_CONTENT_FACTORY));
                continue;
            }
            context.addInstruction(93, deferredInstanceFromFunctionName);
            this.processNode(node, context);
            context.addInstruction(74, new Object[]{deferredInstanceFromFunctionName, 1});
        }
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            return;
        }
        if (instanceNodeCounter == 0) {
            return;
        }
        context.addInstruction(86, instanceNodeCounter);
        context.addInstruction(215);
        Workspace workspace = project.getWorkspace();
        IResolvedQualifiersReference ref = ReferenceFactory.packageQualifiedReference(workspace, deferredInstanceFromFunctionClass);
        IScopedNode scopedNode = anInstanceNode.getContainingScope();
        IASScope iscope = scopedNode.getScope();
        ASScope scope = (ASScope)iscope;
        if (ref == null) assert (false);
        IDefinition def = ref.resolve(project, scope, DependencyType.EXPRESSION, false);
        if (def == null) assert (false);
    }

    void traverse(IASNode node, Context context) {
        this.traverse(node, context, null);
    }

    void traverse(IASNode node, Context context, Predicate<IASNode> filter) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            IASNode child = node.getChild(i);
            if (child instanceof IMXMLNode && !((IMXMLNode)child).isValidForCodeGen() || filter != null && !filter.apply((Object)child) || this.isStateDependentInstance(child)) continue;
            this.processNode(child, context);
        }
    }

    void processNode(IASNode node, Context parentContext) {
        boolean newContextRequired = MXMLClassDirectiveProcessor.isNewContextRequired(node);
        Context childContext = newContextRequired ? this.beginContext(node, parentContext) : parentContext;
        switch (node.getNodeID()) {
            case MXMLBooleanID: {
                this.processMXMLBoolean((IMXMLBooleanNode)node, childContext);
                break;
            }
            case MXMLIntID: {
                this.processMXMLInt((IMXMLIntNode)node, childContext);
                break;
            }
            case MXMLUintID: {
                this.processMXMLUint((IMXMLUintNode)node, childContext);
                break;
            }
            case MXMLNumberID: {
                this.processMXMLNumber((IMXMLNumberNode)node, childContext);
                break;
            }
            case MXMLStringID: {
                this.processMXMLString((IMXMLStringNode)node, childContext);
                break;
            }
            case MXMLClassID: {
                this.processMXMLClass((IMXMLClassNode)node, childContext);
                break;
            }
            case MXMLFunctionID: {
                this.processMXMLFunction((IMXMLFunctionNode)node, childContext);
                break;
            }
            case MXMLObjectID: {
                this.processMXMLObject((IMXMLObjectNode)node, childContext);
                break;
            }
            case MXMLArrayID: {
                if (parentContext.isContentFactory) {
                    childContext.isContentFactory = true;
                }
                this.processMXMLArray((IMXMLArrayNode)node, childContext);
                break;
            }
            case MXMLVectorID: {
                this.processMXMLVector((IMXMLVectorNode)node, childContext);
                break;
            }
            case MXMLInstanceID: 
            case MXMLHTTPServiceID: 
            case MXMLWebServiceID: 
            case MXMLRemoteObjectID: {
                this.processMXMLInstance((IMXMLInstanceNode)node, childContext);
                break;
            }
            case MXMLFactoryID: {
                this.processMXMLFactory((IMXMLFactoryNode)node, childContext);
                break;
            }
            case MXMLDeferredInstanceID: {
                if (parentContext.isContentFactory) {
                    childContext.isContentFactory = true;
                }
                this.processMXMLDeferredInstance((IMXMLDeferredInstanceNode)node, childContext);
                break;
            }
            case MXMLEventSpecifierID: {
                this.processMXMLEventSpecifier((IMXMLEventSpecifierNode)node, childContext);
                break;
            }
            case MXMLHTTPServiceRequestID: 
            case MXMLPropertySpecifierID: {
                this.processMXMLPropertySpecifier((IMXMLPropertySpecifierNode)node, childContext);
                break;
            }
            case MXMLStyleSpecifierID: {
                this.processMXMLStyleSpecifier((IMXMLStyleSpecifierNode)node, childContext);
                break;
            }
            case MXMLEffectSpecifierID: {
                this.processMXMLEffectSpecifier((IMXMLEffectSpecifierNode)node, childContext);
                break;
            }
            case MXMLDeclarationsID: {
                this.processMXMLDeclarations((IMXMLDeclarationsNode)node, childContext);
                break;
            }
            case MXMLScriptID: {
                this.processMXMLScript((IMXMLScriptNode)node, childContext);
                break;
            }
            case MXMLStyleID: {
                this.processMXMLStyle((IMXMLStyleNode)node, childContext);
                break;
            }
            case MXMLMetadataID: {
                this.processMXMLMetadata((IMXMLMetadataNode)node, childContext);
                break;
            }
            case MXMLResourceID: {
                this.processMXMLResource((IMXMLResourceNode)node, childContext);
                break;
            }
            case MXMLStateID: {
                this.processMXMLState((IMXMLStateNode)node, childContext);
                break;
            }
            case MXMLDataBindingID: {
                this.processMXMLDataBinding((IMXMLSingleDataBindingNode)node, childContext);
                break;
            }
            case MXMLConcatenatedDataBindingID: {
                this.processMXMLConcatenatedDataBinding((IMXMLConcatenatedDataBindingNode)node, childContext);
                break;
            }
            case MXMLComponentID: {
                this.processMXMLComponent((IMXMLComponentNode)node, childContext);
                break;
            }
            case MXMLLibraryID: {
                this.processMXMLLibrary((IMXMLLibraryNode)node, childContext);
                break;
            }
            case MXMLDefinitionID: {
                this.processMXMLDefinition((IMXMLDefinitionNode)node, childContext);
                break;
            }
            case MXMLClassDefinitionID: {
                this.processMXMLClassDefinition((IMXMLClassDefinitionNode)node, childContext);
                break;
            }
            case MXMLEmbedID: {
                this.processMXMLEmbed((IMXMLEmbedNode)node, childContext);
                break;
            }
            case MXMLXMLID: {
                this.processMXMLXML((IMXMLXMLNode)node, childContext);
                break;
            }
            case MXMLXMLListID: {
                this.processMXMLXMLList((IMXMLXMLListNode)node, childContext);
                break;
            }
            case MXMLModelID: {
                this.processMXMLModel((IMXMLModelNode)node, childContext);
                break;
            }
            case MXMLModelRootID: {
                this.processMXMLModelRoot((IMXMLModelRootNode)node, childContext);
                break;
            }
            case MXMLModelPropertyID: {
                this.processMXMLModelProperty((IMXMLModelPropertyNode)node, childContext);
                break;
            }
            case MXMLPrivateID: {
                this.processMXMLPrivate((IMXMLPrivateNode)node, childContext);
                break;
            }
            case MXMLWebServiceOperationID: {
                this.processMXMLWebServiceOperation((IMXMLWebServiceOperationNode)node, childContext);
                break;
            }
            case MXMLRemoteObjectMethodID: {
                this.processMXMLRemoteObjectMethod((IMXMLRemoteObjectMethodNode)node, childContext);
                break;
            }
            case MXMLRegExpID: {
                this.processMXMLRegExp((IMXMLRegExpNode)node, childContext);
                break;
            }
            case MXMLClearID: {
                this.processMXMLClear((IMXMLClearNode)node, childContext);
                break;
            }
            case MXMLDesignLayerID: {
                this.processMXMLDesignLayer((IMXMLDesignLayerNode)node, childContext);
                break;
            }
            case MXMLReparentID: {
                this.processMXMLReparent((IMXMLReparentNode)node, childContext);
                break;
            }
            case MXMLBindingID: {
                this.processMXMLBinding((IMXMLBindingNode)node, childContext);
                break;
            }
            case MXMLRepeaterID: {
                this.processMXMLRepeater((IMXMLRepeaterNode)node, childContext);
                break;
            }
            case MXMLImplementsID: {
                this.processMXMLImplements((IMXMLImplementsNode)node, childContext);
            }
            default: {
                super.processNode(node);
            }
        }
        if (newContextRequired) {
            this.endContext(node, childContext, parentContext);
        }
    }

    @Override
    void processDirective(IASNode n) {
        if (!n.getNodeID().isMXMLNode()) {
            switch (n.getNodeID()) {
                case UseID: 
                case ImportID: 
                case IncludeContainerID: 
                case NamespaceID: {
                    break;
                }
                default: {
                    MXMLExecutableStatementsInScriptBlockProblem problem = new MXMLExecutableStatementsInScriptBlockProblem(n);
                    this.getProblems().add(problem);
                }
            }
            super.processDirective(n);
        }
    }

    @Override
    void finishClassDefinition() {
        FunctionDefinition funcDef;
        if (!this.staticVariableInitializers.isEmpty()) {
            InstructionList exisitingCinitInsns = null;
            if (!this.cinitInsns.isEmpty()) {
                exisitingCinitInsns = new InstructionList();
                exisitingCinitInsns.addAll(this.cinitInsns);
                this.cinitInsns = new InstructionList();
            }
            for (VariableNode var : this.staticVariableInitializers) {
                this.generateInstructions(var, true);
            }
            if (exisitingCinitInsns != null) {
                this.cinitInsns.addAll(exisitingCinitInsns);
            }
        }
        ITraitVisitor tv = this.classScope.getGlobalScope().traitsVisitor.visitClassTrait(4, this.className, 0, this.cinfo);
        IMetaInfo[] metaTags = ClassDirectiveProcessor.getAllMetaTags(this.classDefinition);
        this.classScope.processMetadata(tv, metaTags);
        tv.visitEnd();
        this.classScope.callVisitEnds();
        this.iinfo.iInit = new MethodInfo();
        MethodBodyInfo iinit = new MethodBodyInfo();
        iinit.setMethodInfo(this.iinfo.iInit);
        IMethodVisitor mv = this.emitter.visitMethod(this.iinfo.iInit);
        mv.visit();
        IMethodBodyVisitor mbv = mv.visitBody(iinit);
        InstructionList ctor_insns = new InstructionList();
        ctor_insns.addInstruction(208);
        ctor_insns.addInstruction(48);
        ctor_insns.addAll(this.iinitInsns);
        ctor_insns.addInstruction(208);
        ctor_insns.addInstruction(73, 0);
        this.setCurrentState(ctor_insns);
        if (!this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            ctor_insns.addAll(this.iinitAfterSuperInsns);
        } else if (!this.iinitForNonPublicProperties.isEmpty()) {
            ctor_insns.addAll(this.iinitForNonPublicProperties);
        }
        this.addBindingCodeForCtor(ctor_insns);
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData() && this.indexToNodeMap != null && this.indexToNodeMap.size() > 0) {
            ctor_insns.addInstruction(208);
            int numNodes = this.indexToNodeMap.size();
            for (int i = 0; i < numNodes; ++i) {
                IMXMLNode node = this.indexToNodeMap.get(i);
                InstructionList il = this.nodeToInstanceDescriptorMap.get(node);
                ctor_insns.addAll(il);
            }
            ctor_insns.addInstruction(86, numNodes);
            ctor_insns.addInstruction(97, NAME_MXML_STATE_DESCRIPTOR);
        }
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData() && this.numElements > 0 && (funcDef = (FunctionDefinition)SemanticUtils.findProperty(this.classDefinition.getContainedScope(), "generateMXMLAttributes", this.getProject(), false)) != null) {
            Name funcName = funcDef.getMName(this.getProject());
            ctor_insns.addInstruction(208);
            ctor_insns.addAll(this.mxmlPropertiesInsns);
            ctor_insns.addInstruction(79, new Object[]{funcName, 1});
        }
        ctor_insns.addInstruction(71);
        mbv.visit();
        mbv.visitInstructionList(ctor_insns);
        mbv.visitEnd();
        mv.visitEnd();
        if (!this.cinitInsns.isEmpty()) {
            this.cinfo.cInit = new MethodInfo();
            MethodBodyInfo cinit_info = new MethodBodyInfo();
            cinit_info.setMethodInfo(this.cinfo.cInit);
            mv = this.emitter.visitMethod(this.cinfo.cInit);
            mv.visit();
            mbv = mv.visitBody(cinit_info);
            InstructionList cinit_insns = new InstructionList();
            cinit_insns.addInstruction(208);
            cinit_insns.addInstruction(48);
            cinit_insns.addAll(this.cinitInsns);
            cinit_insns.addInstruction(71);
            mbv.visit();
            mbv.visitInstructionList(cinit_insns);
            mbv.visitEnd();
            mv.visitEnd();
        }
        this.itraits.visitEnd();
        this.ctraits.visitEnd();
        this.cv.visitEnd();
    }

    private void setDocumentDescriptorForClass(IMXMLClassDefinitionNode node, Context context) {
        if (node.needsDocumentDescriptor()) {
            this.createDocumentDescriptorVariable(node);
            context.pushTarget();
            this.pushDocumentDescriptor(node, context);
            context.addInstruction(97, MXMLClassDirectiveProcessor.NAME_DOCUMENT_DESCRIPTOR);
            this.overrideInitializeMethod(node);
        }
    }

    private void setDocumentDescriptorForInstance(IMXMLInstanceNode node, Context context) {
        if (node.needsDocumentDescriptor()) {
            context.pushTarget();
            this.pushDocumentDescriptor(node, context);
            context.addInstruction(42);
            context.addInstruction(208);
            context.addInstruction(97, IMXMLTypeConstants.NAME_DOCUMENT);
            context.addInstruction(97, IMXMLTypeConstants.NAME_UNDERBAR_DOCUMENT_DESCRIPTOR);
        }
    }

    private void createDocumentDescriptorVariable(IMXMLClassDefinitionNode node) {
        FlexProject project = this.getProject();
        Name uiComponentDescriptorName = project.getUIComponentDescriptorClassName();
        this.addVariableTrait(NAME_DOCUMENT_DESCRIPTOR, uiComponentDescriptorName);
    }

    private void pushDocumentDescriptor(IMXMLClassReferenceNode node, Context context) {
        this.buildDescriptor(node, context);
        context.transfer(IL.DESCRIPTOR);
    }

    private void buildDescriptor(IMXMLClassReferenceNode node, Context context) {
        context.startUsing(IL.DESCRIPTOR);
        FlexProject project = this.getProject();
        IClassDefinition instanceClass = node.getClassReference(project);
        Name type = ((ClassDefinition)instanceClass).getMName(project);
        String id = node instanceof IMXMLInstanceNode ? ((IMXMLInstanceNode)node).getEffectiveID() : null;
        Name uiComponentDescriptorName = project.getUIComponentDescriptorClassName();
        context.addInstruction(93, uiComponentDescriptorName);
        this.pushDescriptorConstructorArgument(type, id, context);
        context.addInstruction(74, new Object[]{uiComponentDescriptorName, 1});
        context.stopUsing(IL.DESCRIPTOR, 0);
    }

    private void pushDescriptorConstructorArgument(Name type, String id, Context context) {
        MethodInfo methodInfo;
        int counter;
        int n = 0;
        context.addInstruction(44, "type");
        context.addInstruction(96, type);
        ++n;
        if (id != null) {
            context.addInstruction(44, "id");
            context.addInstruction(44, id);
            ++n;
        }
        if ((counter = context.getCounter(IL.DESCRIPTOR_CHILD_DESCRIPTORS)) > 0) {
            context.startUsing(IL.DESCRIPTOR_CHILD_DESCRIPTORS);
            context.addInstruction(86, counter);
            context.stopUsing(IL.DESCRIPTOR_CHILD_DESCRIPTORS, 0);
            context.startUsing(IL.DESCRIPTOR_PROPERTIES);
            context.addInstruction(44, "childDescriptors");
            context.transfer(IL.DESCRIPTOR_CHILD_DESCRIPTORS, IL.DESCRIPTOR_PROPERTIES);
            context.stopUsing(IL.DESCRIPTOR_PROPERTIES, 1);
        }
        if ((counter = context.getCounter(IL.DESCRIPTOR_PROPERTIES)) > 0) {
            context.startUsing(IL.DESCRIPTOR_PROPERTIES);
            context.addInstruction(85, counter);
            context.addInstruction(72);
            context.stopUsing(IL.DESCRIPTOR_PROPERTIES, 0);
            methodInfo = this.createNoParameterAnonymousFunction(IMXMLTypeConstants.NAME_OBJECT, context.get(IL.DESCRIPTOR_PROPERTIES));
            context.remove(IL.DESCRIPTOR_PROPERTIES);
            context.addInstruction(44, "propertiesFactory");
            context.addInstruction(64, methodInfo);
            ++n;
        }
        if ((counter = context.getCounter(IL.DESCRIPTOR_EFFECT_STYLES)) > 0) {
            context.transfer(IL.DESCRIPTOR_EFFECT_STYLES, IL.DESCRIPTOR_STYLES);
            context.incrementCounter(IL.DESCRIPTOR_STYLES, counter);
        }
        if ((counter = context.getCounter(IL.DESCRIPTOR_STYLES)) > 0) {
            context.startUsing(IL.DESCRIPTOR_STYLES);
            context.addInstruction(71);
            context.stopUsing(IL.DESCRIPTOR_STYLES, 0);
            methodInfo = this.createNoParameterAnonymousFunction(IMXMLTypeConstants.NAME_VOID, context.get(IL.DESCRIPTOR_STYLES));
            context.remove(IL.DESCRIPTOR_STYLES);
            context.addInstruction(44, "stylesFactory");
            context.addInstruction(64, methodInfo);
            ++n;
        }
        if ((counter = context.getCounter(IL.DESCRIPTOR_EVENTS)) > 0) {
            context.startUsing(IL.DESCRIPTOR_EVENTS);
            context.addInstruction(85, counter);
            context.stopUsing(IL.DESCRIPTOR_EVENTS, 0);
            context.addInstruction(44, "events");
            context.transfer(IL.DESCRIPTOR_EVENTS);
            ++n;
        }
        if ((counter = context.getCounter(IL.DESCRIPTOR_EFFECTS)) > 0) {
            context.startUsing(IL.DESCRIPTOR_EFFECTS);
            context.addInstruction(86, counter);
            context.stopUsing(IL.DESCRIPTOR_EFFECTS, 0);
            context.addInstruction(44, "effects");
            context.transfer(IL.DESCRIPTOR_EFFECTS);
            ++n;
        }
        context.addInstruction(85, n);
    }

    private void transferDescriptor(IMXMLClassReferenceNode node, Context childContext, Context parentContext) {
        InstructionList descriptorInstructions = childContext.get(IL.DESCRIPTOR);
        childContext.remove(IL.DESCRIPTOR);
        parentContext.startUsing(IL.DESCRIPTOR_CHILD_DESCRIPTORS);
        parentContext.addAll(descriptorInstructions);
        parentContext.stopUsing(IL.DESCRIPTOR_CHILD_DESCRIPTORS, 1);
    }

    private void transferWebServiceOperationsOrRemoteObjectMethods(IMXMLInstanceNode node, Context childContext, Context parentContext) {
        InstructionList childInstructions = childContext.get(IL.WEB_SERVICE_OPERATIONS_OR_REMOTE_OBJECT_METHODS);
        childContext.remove(IL.WEB_SERVICE_OPERATIONS_OR_REMOTE_OBJECT_METHODS);
        parentContext.startUsing(IL.WEB_SERVICE_OPERATIONS_OR_REMOTE_OBJECT_METHODS);
        parentContext.addAll(childInstructions);
        parentContext.stopUsing(IL.WEB_SERVICE_OPERATIONS_OR_REMOTE_OBJECT_METHODS, 1);
    }

    private MethodInfo createNoParameterAnonymousFunction(Name returnType, InstructionList instructionList) {
        MethodInfo mi = new MethodInfo();
        mi.setReturnType(returnType);
        MethodBodyInfo methodBodyInfo = new MethodBodyInfo();
        methodBodyInfo.setMethodInfo(mi);
        IMethodVisitor methodVisitor = this.emitter.visitMethod(mi);
        methodVisitor.visit();
        IMethodBodyVisitor methodBodyVisitor = methodVisitor.visitBody(methodBodyInfo);
        methodBodyVisitor.visit();
        methodBodyVisitor.visitInstructionList(instructionList);
        methodBodyVisitor.visitEnd();
        methodVisitor.visitEnd();
        return mi;
    }

    private void overrideInitializeMethod(IMXMLClassDefinitionNode node) {
        String name = "initialize";
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setMethodName(name);
        methodInfo.setReturnType(IMXMLTypeConstants.NAME_VOID);
        InstructionList body = new InstructionList();
        body.addInstruction(208);
        body.addInstruction(48);
        body.addInstruction(208);
        body.addInstruction(208);
        body.addInstruction(102, NAME_DOCUMENT_DESCRIPTOR);
        body.addInstruction(79, IMXMLTypeConstants.SET_DOCUMENT_DESCRIPTOR_CALL_OPERANDS);
        body.addInstruction(208);
        body.addInstruction(78, IMXMLTypeConstants.INITIALIZE_CALL_OPERANDS);
        body.addInstruction(71);
        this.generateMethodBody(methodInfo, this.classScope, body);
        this.addMethodTrait(IMXMLTypeConstants.NAME_INITIALIZE, methodInfo, true);
    }

    void overrideMXMLPropertiesGetter(IMXMLClassDefinitionNode node, Context context, int numElements) {
        this.addPropertiesData(this.mxmlPropertiesInsns, context, numElements);
    }

    private void addPropertiesData(InstructionList body, Context context, int numElements) {
        this.iinitAfterSuperInsns.addInstruction(86, numElements);
        body.addAll(this.iinitAfterSuperInsns);
    }

    void overrideMXMLDescriptorGetter(IMXMLClassDefinitionNode node, Context context) {
        String name = "MXMLDescriptor";
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setMethodName(name);
        methodInfo.setReturnType(IMXMLTypeConstants.NAME_ARRAY);
        InstructionList body = new InstructionList();
        body.addInstruction(208);
        body.addInstruction(48);
        Label label0 = new Label();
        body.addInstruction(208);
        body.addInstruction(102, NAME_MXML_DESCRIPTOR);
        body.addInstruction(150);
        body.addInstruction(18, label0);
        body.addInstruction(93, NAME_MXML_DESCRIPTOR_GETTER);
        body.addInstruction(4, NAME_MXML_DESCRIPTOR_GETTER);
        body.addInstruction(213);
        this.addInstanceData(body, context);
        body.addInstruction(214);
        Label label1 = new Label();
        body.addInstruction(209);
        body.addInstruction(18, label1);
        body.addInstruction(208);
        body.addInstruction(209);
        body.addInstruction(210);
        body.addInstruction(70, IMXMLTypeConstants.CONCAT_CALL_OPERANDS);
        body.addInstruction(97, NAME_MXML_DESCRIPTOR);
        body.addInstruction(16, label0);
        body.labelNext(label1);
        body.addInstruction(208);
        body.addInstruction(210);
        body.addInstruction(97, NAME_MXML_DESCRIPTOR);
        body.labelNext(label0);
        body.addInstruction(208);
        body.addInstruction(102, NAME_MXML_DESCRIPTOR);
        body.addInstruction(72);
        this.generateMethodBody(methodInfo, this.classScope, body);
        this.addGetter(NAME_MXML_DESCRIPTOR_GETTER, methodInfo, true);
    }

    private void addInstanceData(InstructionList body, Context context) {
        context.startUsing(IL.MXML_CONTENT_FACTORY);
        context.addInstruction(86, context.getCounter(IL.MXML_CONTENT_FACTORY));
        body.addAll(context.currentInstructionList);
        context.stopUsing(IL.MXML_CONTENT_FACTORY, 0);
    }

    void setDocument(IMXMLClassReferenceNode node, boolean conditionally, Context context) {
        if (node.isVisualElementContainer() || node.isContainer()) {
            if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                context.startUsing(IL.PROPERTIES);
                context.addInstruction(44, "document");
                context.addInstruction(38);
                context.addInstruction(208);
                context.stopUsing(IL.PROPERTIES, 1);
                return;
            }
            Label end = null;
            if (conditionally) {
                end = new Label();
                context.pushTarget();
                context.addInstruction(102, IMXMLTypeConstants.NAME_UNDERBAR_DOCUMENT);
                context.addInstruction(32);
                context.addInstruction(20, end);
            }
            context.pushTarget();
            context.addInstruction(208);
            context.addInstruction(97, IMXMLTypeConstants.NAME_UNDERBAR_DOCUMENT);
            if (conditionally) {
                context.labelNext(end);
            }
        }
    }

    private int setSpecifiers(Context context) {
        return this.setSpecifiers(context, false, false);
    }

    int setSpecifiers(Context context, Boolean addCounters, Boolean skipContentFactory) {
        int operationsCount;
        int numElements = 0;
        boolean newCodeGen = this.getProject().getTargetSettings().getMxmlChildrenAsData();
        int numProperties = context.getCounter(IL.PROPERTIES);
        if (context.hasModel) {
            ++numProperties;
        }
        if (context.hasBeads) {
            ++numProperties;
        }
        if (newCodeGen && addCounters.booleanValue()) {
            context.pushNumericConstant(numProperties);
        }
        if (context.hasModel) {
            context.transfer(IL.MXML_MODEL_PROPERTIES);
        }
        context.transfer(IL.PROPERTIES);
        if (context.hasBeads) {
            context.transfer(IL.MXML_BEAD_PROPERTIES);
        }
        if (newCodeGen && addCounters.booleanValue()) {
            context.pushNumericConstant(context.getCounter(IL.STYLES));
        }
        context.transfer(IL.STYLES);
        if (newCodeGen && addCounters.booleanValue()) {
            context.pushNumericConstant(context.getCounter(IL.EFFECT_STYLES));
        }
        context.transfer(IL.EFFECT_STYLES);
        if (newCodeGen && addCounters.booleanValue()) {
            context.pushNumericConstant(context.getCounter(IL.EVENTS));
        }
        context.transfer(IL.EVENTS);
        int n = context.getCounter(IL.EFFECTS);
        if (n > 0) {
            context.pushTarget();
            context.transfer(IL.EFFECTS);
            context.addInstruction(86, n);
            context.addInstruction(79, IMXMLTypeConstants.REGISTER_EFFECTS_CALL_OPERANDS);
        }
        if (newCodeGen && addCounters.booleanValue()) {
            numElements += numProperties * 3;
            numElements += context.getCounter(IL.STYLES) * 3;
            numElements += context.getCounter(IL.EFFECT_STYLES) * 3;
            numElements += context.getCounter(IL.EVENTS) * 2;
            numElements += 4;
            if (context.getCounter(IL.MXML_CONTENT_FACTORY) > 0 && !skipContentFactory.booleanValue()) {
                context.startUsing(IL.MXML_CONTENT_FACTORY);
                InstructionList childIL = context.currentInstructionList;
                context.stopUsing(IL.MXML_CONTENT_FACTORY, 0);
                context.addAll(childIL);
                context.addInstruction(86, context.getCounter(IL.MXML_CONTENT_FACTORY));
            } else {
                context.addInstruction(32);
            }
            ++numElements;
        }
        if (!(newCodeGen && addCounters.booleanValue() || (operationsCount = context.getCounter(IL.WEB_SERVICE_OPERATIONS_OR_REMOTE_OBJECT_METHODS)) <= 0)) {
            context.pushTarget();
            context.transfer(IL.WEB_SERVICE_OPERATIONS_OR_REMOTE_OBJECT_METHODS);
            context.addInstruction(85, operationsCount);
            context.addInstruction(97, IMXMLTypeConstants.NAME_OPERATIONS);
        }
        return numElements;
    }

    private void callInitialized(IMXMLInstanceNode node, Context context) {
        if (node.isMXMLObject()) {
            String id = node.getID();
            context.pushTarget();
            context.addInstruction(208);
            if (id != null) {
                context.addInstruction(44, id);
            } else {
                context.addInstruction(32);
            }
            context.addInstruction(79, IMXMLTypeConstants.INITIALIZED_CALL_OPERANDS);
        }
    }

    private void callAddLayer(IMXMLDesignLayerNode parentNode, Context parentContext, IMXMLDesignLayerNode childNode) {
        assert (!childNode.skipCodeGeneration()) : "No-op DesignLayer tags can't be added to the parent.";
        parentContext.pushTarget();
        parentContext.addInstruction(96, new Name(childNode.getEffectiveID()));
        parentContext.addInstruction(79, IMXMLTypeConstants.ADD_LAYER_CALL_OPERANDS);
    }

    private void setDesignLayer(IMXMLDesignLayerNode designLayerNode, Context designLayerContext, IMXMLInstanceNode childInstanceNode) {
        assert (!designLayerNode.skipCodeGeneration()) : "No-op DesignLayer tags shouldn't be emitted.";
        designLayerContext.pushTarget();
        designLayerContext.addInstruction(96, new Name(childInstanceNode.getEffectiveID()));
        designLayerContext.addInstruction(43);
        designLayerContext.addInstruction(97, IMXMLTypeConstants.NAME_DESIGN_LAYER);
    }

    private void setCurrentState(InstructionList insns) {
        String initialState;
        FlexProject project = this.getProject();
        String stateClientInterface = project.getStateClientInterface();
        if (this.classDefinition.isInstanceOf(stateClientInterface, (ICompilerProject)project) && (initialState = this.classDefinitionNode.getInitialState()) != null) {
            insns.addInstruction(208);
            insns.addInstruction(44, initialState);
            insns.addInstruction(97, IMXMLTypeConstants.NAME_CURRENT_STATE);
        }
    }

    private void addBindingCodeForCtor(InstructionList ctor_insns) {
        InstructionList il = this.bindingDirectiveHelper.getConstructorCode();
        if (il != null) {
            ctor_insns.addAll(il);
        }
    }

    public FlexProject getProject() {
        return (FlexProject)this.classScope.getProject();
    }

    public Collection<ICompilerProblem> getProblems() {
        return this.classScope.getProblems();
    }

    private Name getInstanceInitializerName(IMXMLInstanceNode instanceNode) {
        Name name = this.instanceInitializerMap.get(instanceNode);
        if (name != null) {
            return name;
        }
        name = MXMLClassDirectiveProcessor.createMXMLPrivateName(INSTANCE_INITIALIZER_NAME_BASE + this.instanceInitializerCounter++);
        this.instanceInitializerMap.put(instanceNode, name);
        return name;
    }

    public Name getEventHandlerName(IMXMLEventSpecifierNode eventNode) {
        Name name = this.eventHandlerMap.get(eventNode);
        if (name != null) {
            return name;
        }
        String baseName = EVENT_HANDLER_NAME_BASE + this.eventHandlerCounter++;
        name = eventNode.needsPublicHandler() ? new Name(baseName) : MXMLClassDirectiveProcessor.createMXMLPrivateName(baseName);
        this.eventHandlerMap.put(eventNode, name);
        return name;
    }

    public Name getVectorGeneratorName(Name typeName) {
        Name name = this.VectorGeneratorMap.get(typeName);
        if (name != null) {
            return name;
        }
        String baseName = VECTOR_GENERATOR_NAME_BASE + this.vectorGeneratorCounter++;
        name = MXMLClassDirectiveProcessor.createMXMLPrivateName(baseName);
        this.VectorGeneratorMap.put(typeName, name);
        return name;
    }

    protected boolean isStateDependent(IASNode node) {
        if (node instanceof IMXMLSpecifierNode) {
            String suffix = ((IMXMLSpecifierNode)node).getSuffix();
            return suffix != null && suffix.length() > 0;
        }
        return this.isStateDependentInstance(node);
    }

    protected boolean isStateDependentInstance(IASNode node) {
        if (node instanceof IMXMLInstanceNode) {
            String[] includeIn = ((IMXMLInstanceNode)node).getIncludeIn();
            String[] excludeFrom = ((IMXMLInstanceNode)node).getExcludeFrom();
            return includeIn != null || excludeFrom != null;
        }
        return false;
    }

    private void addMethodTrait(Name methodName, MethodInfo methodInfo, boolean isOverride) {
        ITraitVisitor traitVisitor = this.itraits.visitMethodTrait(1, methodName, 0, methodInfo);
        if (isOverride) {
            traitVisitor.visitAttribute("override", true);
        }
    }

    public void addVariableTrait(Name varName, Name varType) {
        this.itraits.visitSlotTrait(0, varName, 0, varType, LexicalScope.noInitializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBindableVariableTrait(Name varName, Name varType, IDefinition def) {
        ITraitsVisitor old_tv = this.classScope.traitsVisitor;
        try {
            this.classScope.traitsVisitor = this.itraits;
            Binding var = this.classScope.getBinding(def);
            this.classScope.makeBindableVariable(var, varType, var.getDefinition().getAllMetaTags());
        }
        finally {
            this.classScope.traitsVisitor = old_tv;
        }
    }

    private void addGetter(Name methodName, MethodInfo methodInfo, boolean isOverride) {
        ITraitVisitor traitVisitor = this.itraits.visitMethodTrait(2, methodName, 0, methodInfo);
        if (isOverride) {
            traitVisitor.visitAttribute("override", true);
        }
    }

    private void addSetter(Name methodName, MethodInfo methodInfo, boolean isOverride) {
        ITraitVisitor traitVisitor = this.itraits.visitMethodTrait(3, methodName, 0, methodInfo);
        if (isOverride) {
            traitVisitor.visitAttribute("override", true);
        }
    }

    private MethodInfo generateMethodBody(MethodInfo mi, LexicalScope enclosing_scope, InstructionList instructions) {
        IMethodVisitor mv = enclosing_scope.getEmitter().visitMethod(mi);
        mv.visit();
        MethodBodyInfo mbi = new MethodBodyInfo();
        mbi.setMethodInfo(mi);
        IMethodBodyVisitor mbv = mv.visitBody(mbi);
        mbv.visit();
        mbv.visitInstructionList(instructions);
        mbv.visitEnd();
        mv.visitEnd();
        return mi;
    }

    private boolean instanceRequiresInitializerMethod(IMXMLInstanceNode instanceNode) {
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            return false;
        }
        if (instanceNode.getParent() instanceof IMXMLDeferredInstanceNode) {
            return true;
        }
        return this.isStateDependent(instanceNode);
    }

    protected boolean generateDescriptorCode(IASNode node, Context context) {
        if (node instanceof IMXMLSpecifierNode && ((IMXMLClassReferenceNode)node.getParent()).needsDocumentDescriptor()) {
            return false;
        }
        if (node instanceof IMXMLClassReferenceNode && ((IMXMLClassReferenceNode)node).needsDocumentDescriptor()) {
            return false;
        }
        return context.needsDescriptor;
    }

    private boolean generateNonDescriptorCode(IASNode node, Context context) {
        if (node instanceof IMXMLSpecifierNode) {
            node = node.getParent();
        }
        if (node instanceof IMXMLInstanceNode && !((IMXMLInstanceNode)node).isDeferredInstantiationUIComponent()) {
            return true;
        }
        IASNode parent = node.getParent();
        if (parent != null && parent instanceof IMXMLClassReferenceNode) {
            return !((IMXMLClassReferenceNode)parent).isContainer();
        }
        return true;
    }

    private static boolean isNewContextRequired(IASNode node) {
        boolean isInstanceNode = node instanceof IMXMLInstanceNode;
        boolean isResourceNode = node instanceof IMXMLResourceNode;
        boolean isDesignLayerNode = node instanceof IMXMLDesignLayerNode;
        boolean isDataBindingNode = MXMLClassDirectiveProcessor.isDataBindingNode(node);
        return isInstanceNode && !isDesignLayerNode && !isDataBindingNode && !isResourceNode;
    }

    private Context beginContext(IASNode node, Context parentContext) {
        FlexProject project;
        IClassDefinition instanceClassReference;
        boolean isMXMLDisplayObjectChild;
        IMXMLInstanceNode instanceNode = (IMXMLInstanceNode)node;
        boolean bl = isMXMLDisplayObjectChild = node.getNodeID() == ASTNodeID.MXMLInstanceID && (node.getParent().getNodeID() == ASTNodeID.MXMLInstanceID || node.getParent().getNodeID() == ASTNodeID.MXMLDocumentID);
        if (isMXMLDisplayObjectChild) {
            parentContext.startUsing(IL.MXML_CONTENT_FACTORY);
            parentContext.isContentFactory = true;
        }
        Context childContext = new Context(instanceNode, parentContext.currentInstructionList);
        childContext.parentContext = parentContext;
        if (isMXMLDisplayObjectChild) {
            parentContext.stopUsing(IL.MXML_CONTENT_FACTORY, 0);
        }
        Name name = childContext.instanceClassName = (instanceClassReference = instanceNode.getClassReference(project = this.getProject())) != null ? ((DefinitionBase)((Object)instanceClassReference)).getMName(project) : null;
        if (this.instanceRequiresInitializerMethod(instanceNode)) {
            childContext.instanceHasOwnInitializer = true;
            childContext.currentInstructionList = (childContext.mainInstructionList = new InstructionList());
            childContext.addInstruction(208);
            childContext.addInstruction(48);
        }
        return childContext;
    }

    private void endContext(IASNode node, Context childContext, Context parentContext) {
        IASNode parent;
        String id;
        boolean generateDescriptorCode = this.generateDescriptorCode((IMXMLInstanceNode)node, childContext);
        boolean generateNonDescriptorCode = this.generateNonDescriptorCode((IMXMLInstanceNode)node, childContext);
        boolean isInitializer = childContext.instanceHasOwnInitializer;
        if (generateDescriptorCode && !isInitializer) {
            this.transferDescriptor((IMXMLInstanceNode)node, childContext, parentContext);
        }
        if (node instanceof IMXMLWebServiceOperationNode || node instanceof IMXMLRemoteObjectMethodNode) {
            this.transferWebServiceOperationsOrRemoteObjectMethods((IMXMLInstanceNode)node, childContext, parentContext);
        }
        IMXMLInstanceNode instanceNode = (IMXMLInstanceNode)childContext.node;
        Name instanceClassName = childContext.instanceClassName;
        if (!this.getProject().getTargetSettings().getMxmlChildrenAsData() && generateNonDescriptorCode) {
            this.callInitialized(instanceNode, childContext);
            this.setDocument(instanceNode, true, childContext);
            this.setDocumentDescriptorForInstance(instanceNode, childContext);
        }
        if ((id = instanceNode.getEffectiveID()) != null) {
            Name idName = new Name(id);
            if (instanceNode.getID() != null) {
                IVariableDefinition d = instanceNode.resolveID();
                ClassDefinition base = (ClassDefinition)this.classDefinition.resolveBaseClass(this.getProject());
                if (base != null) {
                    IDefinition baseDef = base.getContainedScope().getQualifiedPropertyFromDef((ICompilerProject)this.getProject(), (IDefinition)base, d.getBaseName(), NamespaceDefinition.getPublicNamespaceDefinition(), false);
                    if (baseDef == null) {
                        this.addBindableVariableTrait(idName, instanceClassName, d);
                    }
                } else {
                    this.addBindableVariableTrait(idName, instanceClassName, d);
                }
            } else {
                this.addVariableTrait(idName, instanceClassName);
            }
            if (!this.getProject().getTargetSettings().getMxmlChildrenAsData() && (generateNonDescriptorCode || this.isStateDependentInstance(instanceNode))) {
                this.setIDReferenceVariable(idName, childContext);
                if (MXMLClassDirectiveProcessor.instanceAffectsBindings(instanceNode)) {
                    this.executeBindingsForInstance(instanceNode, childContext);
                }
            }
        }
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            return;
        }
        Name initializerName = null;
        if (isInitializer) {
            initializerName = this.getInstanceInitializerName(instanceNode);
            MethodInfo methodInfo = MXMLClassDirectiveProcessor.createInstanceInitializerMethodInfo(initializerName.getBaseName(), instanceClassName);
            this.addMethodTrait(initializerName, methodInfo, false);
            childContext.addInstruction(72);
            this.generateMethodBody(methodInfo, this.classScope, childContext.currentInstructionList);
        }
        if (isInitializer) {
            parentContext.addInstruction(208);
            if (node.getParent() instanceof IMXMLDeferredInstanceNode && !(node instanceof IMXMLClassNode) || this.isStateDependent(node)) {
                parentContext.addInstruction(102, new Object[]{initializerName, 0});
            } else {
                parentContext.addInstruction(70, new Object[]{initializerName, 0});
            }
        }
        if (generateNonDescriptorCode && ((parent = node.getParent()) instanceof IMXMLDeclarationsNode || parent instanceof IMXMLClassDefinitionNode && ((IMXMLInstanceNode)node).isDeferredInstantiationUIComponent())) {
            childContext.addInstruction(41);
        }
    }

    private void setIDReferenceVariable(Name idName, Context context) {
        context.addInstruction(42);
        context.addInstruction(208);
        context.addInstruction(43);
        context.addInstruction(97, idName);
    }

    boolean isDataBound(IMXMLExpressionNode node) {
        IASNode n = node.getExpressionNode();
        return n == null || MXMLClassDirectiveProcessor.isDataBindingNode(n);
    }

    boolean isChildrenAsDataCodeGen(IMXMLExpressionNode node, Context context) {
        if (context.parentContext.makingSimpleArray) {
            return false;
        }
        if (context.parentContext.nonPublic) {
            return false;
        }
        return this.getProject().getTargetSettings().getMxmlChildrenAsData() && (node.getParent().getNodeID() == ASTNodeID.MXMLPropertySpecifierID || node.getParent().getNodeID() == ASTNodeID.MXMLStyleSpecifierID);
    }

    void processMXMLBoolean(IMXMLBooleanNode booleanNode, Context context) {
        if (this.isChildrenAsDataCodeGen(booleanNode, context)) {
            context.addInstruction(38);
        }
        boolean value = this.isDataBound(booleanNode) ? false : booleanNode.getValue();
        context.addInstruction(value ? 38 : 39);
        this.traverse(booleanNode, context);
    }

    void processMXMLInt(IMXMLIntNode intNode, Context context) {
        if (this.isChildrenAsDataCodeGen(intNode, context)) {
            context.addInstruction(38);
        }
        int value = this.isDataBound(intNode) ? 0 : intNode.getValue();
        context.pushNumericConstant(value);
        this.traverse(intNode, context);
    }

    void processMXMLUint(IMXMLUintNode uintNode, Context context) {
        if (this.isChildrenAsDataCodeGen(uintNode, context)) {
            context.addInstruction(38);
        }
        long value = this.isDataBound(uintNode) ? 0L : uintNode.getValue();
        context.addInstruction(46, new Object[]{value});
        this.traverse(uintNode, context);
    }

    void processMXMLNumber(IMXMLNumberNode numberNode, Context context) {
        if (this.isChildrenAsDataCodeGen(numberNode, context)) {
            context.addInstruction(38);
        }
        double value = this.isDataBound(numberNode) ? Double.NaN : numberNode.getValue();
        context.addInstruction(47, new Object[]{value});
        this.traverse(numberNode, context);
    }

    void processMXMLString(IMXMLStringNode stringNode, Context context) {
        String value;
        if (this.isChildrenAsDataCodeGen(stringNode, context)) {
            context.addInstruction(38);
        }
        String string = value = this.isDataBound(stringNode) ? null : stringNode.getValue();
        if (value != null) {
            context.addInstruction(44, new Object[]{value});
        } else {
            context.addInstruction(32);
        }
        this.traverse(stringNode, context);
    }

    void processMXMLClass(IMXMLClassNode classNode, Context context) {
        IExpressionNode expressionNode;
        if (MXMLClassDirectiveProcessor.isDataBindingNode(classNode)) {
            return;
        }
        if (this.isChildrenAsDataCodeGen(classNode, context)) {
            context.addInstruction(38);
        }
        if ((expressionNode = (IExpressionNode)classNode.getExpressionNode()) != null) {
            InstructionList init_expression = this.classScope.getGenerator().generateInstructions(expressionNode, 18, this.classScope);
            context.addAll(init_expression);
        } else {
            context.addInstruction(32);
        }
    }

    void processMXMLFunction(IMXMLFunctionNode functionNode, Context context) {
        IExpressionNode expressionNode;
        if (MXMLClassDirectiveProcessor.isDataBindingNode(functionNode)) {
            return;
        }
        if (this.isChildrenAsDataCodeGen(functionNode, context)) {
            context.addInstruction(38);
        }
        if ((expressionNode = (IExpressionNode)functionNode.getExpressionNode()) != null) {
            InstructionList init_expression = this.classScope.getGenerator().generateInstructions(expressionNode, 18, this.classScope);
            context.addAll(init_expression);
        } else {
            context.addInstruction(32);
        }
    }

    void processMXMLRegExp(IMXMLRegExpNode regexpNode, Context context) {
        if (MXMLClassDirectiveProcessor.isDataBindingNode(regexpNode)) {
            return;
        }
        IExpressionNode expressionNode = (IExpressionNode)regexpNode.getExpressionNode();
        if (expressionNode != null) {
            InstructionList init_expression = this.classScope.getGenerator().generateInstructions(expressionNode, 18, this.classScope);
            context.addAll(init_expression);
        } else {
            context.addInstruction(93, ABCGeneratingReducer.regexType);
            context.addInstruction(74, new Object[]{ABCGeneratingReducer.regexType, 0});
        }
    }

    void processMXMLDesignLayer(IMXMLDesignLayerNode node, Context context) {
        this.traverse(node, context, MXML_INSTANCE_NODES);
        if (node.skipCodeGeneration()) {
            return;
        }
        Context designLayerInstanceContext = this.beginContext(node, context);
        this.emitDesignLayerInstance(node, designLayerInstanceContext);
        this.endContext(node, designLayerInstanceContext, context);
        if (!this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.mainInstructionList.addInstruction(41);
        }
    }

    private void emitDesignLayerInstance(IMXMLDesignLayerNode node, Context context) {
        boolean newCodeGen = this.getProject().getTargetSettings().getMxmlChildrenAsData();
        this.traverse(node, context, MXML_SPECIFIER_NODES);
        Name instanceClassName = context.instanceClassName;
        context.addInstruction(93, instanceClassName);
        context.addInstruction(74, new Object[]{instanceClassName, 0});
        int numElements = this.setSpecifiers(context, newCodeGen, false);
        ++numElements;
        if (!newCodeGen) {
            this.callInitialized(node, context);
            for (int i = 0; i < node.getChildCount(); ++i) {
                IASNode child = node.getChild(i);
                if (child instanceof IMXMLDesignLayerNode) {
                    IMXMLDesignLayerNode designLayerChildNode = (IMXMLDesignLayerNode)child;
                    if (designLayerChildNode.skipCodeGeneration()) continue;
                    this.callAddLayer(node, context, designLayerChildNode);
                    continue;
                }
                if (!(child instanceof IMXMLInstanceNode)) continue;
                IMXMLInstanceNode instanceChildNode = (IMXMLInstanceNode)child;
                this.setDesignLayer(node, context, instanceChildNode);
            }
        } else if (context.parentContext.isContentFactory) {
            context.parentContext.incrementCounter(IL.MXML_CONTENT_FACTORY, numElements);
        } else if (!context.parentContext.isContentFactory) {
            if (context.parentContext.makingArrayValues) {
                context.parentContext.numArrayValues += numElements;
            } else {
                context.addInstruction(86, numElements);
            }
        }
    }

    void processMXMLWebServiceOperation(IMXMLWebServiceOperationNode node, Context context) {
        this.processOperationOrMethod(node, context, node.getOperationName());
    }

    void processMXMLRemoteObjectMethod(IMXMLRemoteObjectMethodNode node, Context context) {
        this.processOperationOrMethod(node, context, node.getMethodName());
    }

    void processOperationOrMethod(IMXMLInstanceNode node, Context context, String name) {
        if (!Strings.isNullOrEmpty((String)name)) {
            context.startUsing(IL.WEB_SERVICE_OPERATIONS_OR_REMOTE_OBJECT_METHODS);
            context.addInstruction(44, name);
            this.processMXMLInstance(node, context);
            context.stopUsing(IL.WEB_SERVICE_OPERATIONS_OR_REMOTE_OBJECT_METHODS, 1);
        }
    }

    void processMXMLObject(IMXMLObjectNode objectNode, Context context) {
        boolean newCodeGen = this.getProject().getTargetSettings().getMxmlChildrenAsData();
        context.makingSimpleArray = context.parentContext.makingSimpleArray;
        if (newCodeGen && !context.isStateDescriptor && !context.parentContext.isContentFactory && !context.parentContext.makingArrayValues) {
            context.addInstruction(39);
        }
        if (newCodeGen && !context.makingSimpleArray) {
            context.addInstruction(93, IMXMLTypeConstants.NAME_OBJECT);
            context.addInstruction(102, IMXMLTypeConstants.NAME_OBJECT);
        }
        this.traverse(objectNode, context);
        int numElements = context.getCounter(IL.PROPERTIES);
        if (newCodeGen && !context.makingSimpleArray) {
            context.pushNumericConstant(numElements);
        }
        context.transfer(IL.PROPERTIES);
        if (!newCodeGen || context.makingSimpleArray) {
            int n = objectNode.getChildCount();
            context.addInstruction(85, n);
        } else {
            context.pushNumericConstant(context.getCounter(IL.STYLES));
            context.pushNumericConstant(context.getCounter(IL.EFFECT_STYLES));
            context.pushNumericConstant(context.getCounter(IL.EVENTS));
            context.addInstruction(32);
            numElements *= 3;
            numElements += 6;
            if (context.parentContext.isContentFactory) {
                context.parentContext.incrementCounter(IL.MXML_CONTENT_FACTORY, numElements);
            } else if (!context.parentContext.isContentFactory) {
                if (context.parentContext.makingArrayValues) {
                    context.parentContext.numArrayValues += numElements;
                } else {
                    context.addInstruction(86, numElements);
                }
            }
        }
    }

    void processMXMLArray(IMXMLArrayNode arrayNode, Context context) {
        boolean isSimple = true;
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData() && !context.isContentFactory) {
            if (context.parentContext.isStateDescriptor) {
                context.addInstruction(32);
            } else if (!context.parentContext.makingSimpleArray) {
                for (int i = 0; i < arrayNode.getChildCount(); ++i) {
                    IASNode child = arrayNode.getChild(i);
                    ASTNodeID nodeID = child.getNodeID();
                    if (nodeID != ASTNodeID.MXMLArrayID && nodeID != ASTNodeID.MXMLInstanceID) continue;
                    isSimple = false;
                    break;
                }
                context.makingArrayValues = true;
                context.makingSimpleArray = isSimple;
                context.addInstruction(isSimple ? 38 : 32);
            }
        }
        this.traverse(arrayNode, context);
        int nMax = arrayNode.getChildCount();
        int numStateDependentChildren = 0;
        for (int i = 0; i < nMax; ++i) {
            IASNode ch = arrayNode.getChild(i);
            if (!this.isStateDependentInstance(ch)) continue;
            ++numStateDependentChildren;
        }
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            if (context.isContentFactory) {
                context.parentContext.incrementCounter(IL.MXML_CONTENT_FACTORY, context.getCounter(IL.MXML_CONTENT_FACTORY));
                return;
            }
            if (context.parentContext.isStateDescriptor) {
                context.addInstruction(86, context.getCounter(IL.MXML_STATES_ARRAY));
                return;
            }
            if (context.makingArrayValues) {
                if (isSimple) {
                    context.addInstruction(86, nMax);
                } else {
                    context.addInstruction(86, context.numArrayValues);
                }
                return;
            }
        }
        int arraySize = MXMLClassDirectiveProcessor.getChildCountAfterFlattenDesignLayers(arrayNode) - numStateDependentChildren;
        context.addInstruction(86, arraySize);
    }

    private static int getChildCountAfterFlattenDesignLayers(IASNode node) {
        int result = 0;
        for (int i = 0; i < node.getChildCount(); ++i) {
            IASNode child = node.getChild(i);
            if (child instanceof IMXMLDesignLayerNode) {
                result += ((IMXMLDesignLayerNode)child).getHoistedChildCount();
                continue;
            }
            if (child instanceof IMXMLScriptNode) continue;
            ++result;
        }
        return result;
    }

    Name generateVectorGenerator(Name typeName, IMXMLVectorNode vectorNode) {
        Name name = this.getVectorGeneratorName(typeName);
        MethodInfo methodInfo = MXMLClassDirectiveProcessor.createVectorGeneratorMethodInfo(this.getProject(), vectorNode, name.getBaseName());
        this.addMethodTrait(name, methodInfo, false);
        FlexProject project = this.getProject();
        ASProjectScope projectScope = (ASProjectScope)project.getScope();
        IDefinition vectorDef = projectScope.findDefinitionByName(IASLanguageConstants.Vector_qname);
        Name vectorName = ((ClassDefinition)vectorDef).getMName(project);
        InstructionList generatorFunctionBody = new InstructionList();
        generatorFunctionBody.addInstruction(208);
        generatorFunctionBody.addInstruction(48);
        generatorFunctionBody.addInstruction(96, vectorName);
        generatorFunctionBody.addInstruction(96, typeName);
        generatorFunctionBody.addInstruction(83, 1);
        generatorFunctionBody.addInstruction(100);
        generatorFunctionBody.addInstruction(209);
        generatorFunctionBody.addInstruction(65, 1);
        generatorFunctionBody.addInstruction(72);
        FunctionGeneratorHelper.generateFunction(this.emitter, methodInfo, generatorFunctionBody);
        return name;
    }

    void processMXMLVector(IMXMLVectorNode vectorNode, Context context) {
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.addInstruction(33);
        }
        FlexProject project = this.getProject();
        int n = vectorNode.getChildCount();
        ITypeDefinition type = vectorNode.getType();
        if (type instanceof IAppliedVectorDefinition) {
            type = ((IAppliedVectorDefinition)vectorNode.getType()).resolveElementType(project);
        }
        boolean fixed = vectorNode.getFixed();
        ASProjectScope projectScope = (ASProjectScope)project.getScope();
        IDefinition vectorDef = projectScope.findDefinitionByName(IASLanguageConstants.Vector_qname);
        Name vectorName = ((ClassDefinition)vectorDef).getMName(project);
        Name typeName = ((TypeDefinitionBase)type).getMName(project);
        Nsset nsSet = new Nsset(new Namespace(22));
        Name indexName = new Name(27, nsSet, null);
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.addInstruction(96, typeName);
            Name vectorGenerator = this.generateVectorGenerator(typeName, vectorNode);
            context.addInstruction(208);
            context.addInstruction(102, vectorGenerator);
            context.makingArrayValues = true;
            for (int i = 0; i < n; ++i) {
                IMXMLInstanceNode elementNode = (IMXMLInstanceNode)vectorNode.getChild(i);
                this.processNode(elementNode, context);
            }
            context.addInstruction(86, context.numArrayValues + 2);
            context.makingArrayValues = false;
        } else {
            context.addInstruction(96, vectorName);
            context.addInstruction(96, typeName);
            context.addInstruction(83, 1);
            context.pushNumericConstant(n);
            if (fixed) {
                context.addInstruction(38);
            }
            context.addInstruction(66, fixed ? 2 : 1);
            for (int i = 0; i < n; ++i) {
                context.addInstruction(42);
                context.pushNumericConstant(i);
                IMXMLInstanceNode elementNode = (IMXMLInstanceNode)vectorNode.getChild(i);
                this.processNode(elementNode, context);
                context.addInstruction(97, indexName);
            }
        }
    }

    void processMXMLInstance(IMXMLInstanceNode instanceNode, Context context) {
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData() && !context.isStateDescriptor && !context.parentContext.isContentFactory && !context.parentContext.makingArrayValues) {
            context.addInstruction(39);
        }
        this.traverse(instanceNode, context);
        if (!this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            if (this.generateDescriptorCode(instanceNode, context) && !context.instanceHasOwnInitializer) {
                this.buildDescriptor(instanceNode, context);
            }
            if (this.generateNonDescriptorCode(instanceNode, context) || context.instanceHasOwnInitializer) {
                Name instanceClassName = context.instanceClassName;
                context.addInstruction(93, instanceClassName);
                context.addInstruction(74, new Object[]{instanceClassName, 0});
                this.setSpecifiers(context);
                String id = instanceNode.getID();
                if (id != null && instanceNode.isDeferredInstantiationUIComponent()) {
                    context.pushTarget();
                    context.addInstruction(44, id);
                    context.addInstruction(97, IMXMLTypeConstants.NAME_ID);
                }
            }
        } else {
            String id;
            int numElements = 0;
            context.addInstruction(93, context.instanceClassName);
            context.addInstruction(102, context.instanceClassName);
            if (context.parentContext.isContentFactory) {
                if (context.isStateDescriptor) {
                    context.parentContext.incrementCounter(IL.MXML_STATES_ARRAY, 1);
                } else {
                    context.parentContext.incrementCounter(IL.MXML_CONTENT_FACTORY, 1);
                }
            } else if (!context.parentContext.isContentFactory) {
                numElements = 1;
            }
            if (!this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                this.setDocument(instanceNode, false, context);
            }
            if ((id = instanceNode.getID()) != null) {
                context.startUsing(IL.PROPERTIES);
                context.addInstruction(44, "id");
                context.addInstruction(38);
                context.addInstruction(44, id);
                context.stopUsing(IL.PROPERTIES, 1);
            } else {
                id = instanceNode.getEffectiveID();
                if (id != null) {
                    context.startUsing(IL.PROPERTIES);
                    context.addInstruction(44, "_id");
                    context.addInstruction(38);
                    context.addInstruction(44, id);
                    context.stopUsing(IL.PROPERTIES, 1);
                }
            }
            if (context.isStateDescriptor) {
                return;
            }
            numElements += this.setSpecifiers(context, true, false);
            if (context.parentContext.isContentFactory) {
                context.parentContext.incrementCounter(IL.MXML_CONTENT_FACTORY, numElements);
            } else if (!context.parentContext.isContentFactory) {
                if (context.parentContext.makingArrayValues) {
                    context.parentContext.numArrayValues += numElements;
                } else {
                    context.addInstruction(86, numElements);
                }
            }
        }
    }

    private void executeBindingsForInstance(IMXMLInstanceNode instanceNode, Context context) {
        if (!instanceNode.getClassDefinitionNode().getHasDataBindings()) {
            return;
        }
        FlexProject project = this.getProject();
        Name bindingManagerName = project.getBindingManagerClassName();
        String id = instanceNode.getEffectiveID();
        if (id == null) {
            return;
        }
        context.addInstruction(42);
        context.addInstruction(213);
        context.addInstruction(96, bindingManagerName);
        context.addInstruction(208);
        context.addInstruction(44, id);
        context.addInstruction(209);
        context.addInstruction(79, IMXMLTypeConstants.EXECUTE_BINDINGS_CALL_OPERANDS);
    }

    void processMXMLFactory(IMXMLFactoryNode factoryNode, Context context) {
        FlexProject project;
        ClassDefinition classReference;
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.addInstruction(38);
        }
        Name factoryClassName = (classReference = (ClassDefinition)factoryNode.getClassReference(project = this.getProject())) != null ? classReference.getMName(project) : null;
        context.addInstruction(95, factoryClassName);
        this.traverse(factoryNode, context);
        context.addInstruction(74, new Object[]{factoryClassName, 1});
    }

    void processMXMLDeferredInstance(IMXMLDeferredInstanceNode deferredInstanceNode, Context context) {
        if (!this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            FlexProject project = this.getProject();
            ClassDefinition classReference = (ClassDefinition)deferredInstanceNode.getClassReference(project);
            Name deferredInstanceClassName = classReference.getMName(project);
            context.addInstruction(95, deferredInstanceClassName);
            this.traverse(deferredInstanceNode, context);
            context.addInstruction(74, new Object[]{deferredInstanceClassName, 1});
        } else {
            this.traverse(deferredInstanceNode, context);
            if (context.isContentFactory) {
                context.parentContext.incrementCounter(IL.MXML_CONTENT_FACTORY, context.getCounter(IL.MXML_CONTENT_FACTORY));
                return;
            }
        }
    }

    void processMXMLPropertySpecifier(IMXMLPropertySpecifierNode propertyNode, Context context) {
        if (this.isStateDependent(propertyNode)) {
            return;
        }
        String propertyName = propertyNode.getName();
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            if (propertyName.equals("mxmlContentFactory") || propertyName.equals("mxmlContent")) {
                context.startUsing(IL.MXML_CONTENT_FACTORY);
                context.isContentFactory = true;
                this.traverse(propertyNode, context, MXML_INSTANCE_NODES);
                context.isContentFactory = false;
                context.stopUsing(IL.MXML_CONTENT_FACTORY, 0);
            } else if (propertyName.equals("states")) {
                context.isStateDescriptor = true;
                context.startUsing(IL.PROPERTIES);
                context.addInstruction(44, propertyName);
                this.traverse(propertyNode, context);
                context.stopUsing(IL.PROPERTIES, 1);
                context.isStateDescriptor = false;
            } else if (propertyName.equals("model")) {
                context.hasModel = true;
                context.startUsing(IL.MXML_MODEL_PROPERTIES);
                context.addInstruction(44, propertyName);
                this.traverse(propertyNode, context);
                context.stopUsing(IL.MXML_MODEL_PROPERTIES, 1);
            } else if (propertyName.equals("beads")) {
                context.hasBeads = true;
                context.startUsing(IL.MXML_BEAD_PROPERTIES);
                context.addInstruction(44, propertyName);
                this.traverse(propertyNode, context, MXML_INSTANCE_NODES);
                context.stopUsing(IL.MXML_BEAD_PROPERTIES, 1);
            } else if (!MXMLClassDirectiveProcessor.isDataboundProp(propertyNode)) {
                IDefinition propDef = propertyNode.getDefinition();
                if (propDef == null && propertyNode.getParent() instanceof IMXMLObjectNode) {
                    context.startUsing(IL.PROPERTIES);
                    context.addInstruction(44, propertyName);
                    this.traverse(propertyNode, context);
                    context.stopUsing(IL.PROPERTIES, 1);
                } else if (propDef.isPublic()) {
                    context.startUsing(IL.PROPERTIES);
                    context.addInstruction(44, propertyName);
                    this.traverse(propertyNode, context);
                    context.stopUsing(IL.PROPERTIES, 1);
                } else {
                    Context tempContext = new Context(this.classDefinitionNode, this.iinitForNonPublicProperties);
                    tempContext.nonPublic = true;
                    tempContext.pushTarget();
                    this.traverse(propertyNode, tempContext);
                    Name n = ((DefinitionBase)propDef).getMName(this.getProject());
                    tempContext.addInstruction(97, n);
                }
            } else {
                IMXMLInstanceNode instanceNode = propertyNode.getInstanceNode();
                if (instanceNode instanceof IMXMLSingleDataBindingNode) {
                    this.processMXMLDataBinding((IMXMLSingleDataBindingNode)instanceNode, context);
                } else if (instanceNode instanceof IMXMLConcatenatedDataBindingNode) {
                    this.processMXMLConcatenatedDataBinding((IMXMLConcatenatedDataBindingNode)instanceNode, context);
                }
            }
            return;
        }
        boolean isDb = MXMLClassDirectiveProcessor.isDataboundProp(propertyNode);
        if (this.generateDescriptorCode(propertyNode, context)) {
            if (!isDb) {
                context.startUsing(IL.DESCRIPTOR_PROPERTIES);
                context.addInstruction(44, propertyName);
                this.traverse(propertyNode, context);
                context.stopUsing(IL.DESCRIPTOR_PROPERTIES, 1);
            } else {
                IMXMLInstanceNode instanceNode = propertyNode.getInstanceNode();
                if (instanceNode instanceof IMXMLSingleDataBindingNode) {
                    this.processMXMLDataBinding((IMXMLSingleDataBindingNode)instanceNode, context);
                } else if (instanceNode instanceof IMXMLConcatenatedDataBindingNode) {
                    this.processMXMLConcatenatedDataBinding((IMXMLConcatenatedDataBindingNode)instanceNode, context);
                }
            }
        }
        if (this.generateNonDescriptorCode(propertyNode, context)) {
            context.startUsing(IL.PROPERTIES);
            if (propertyNode.getParent().getNodeID() == ASTNodeID.MXMLObjectID) {
                context.addInstruction(44, propertyName);
                this.traverse(propertyNode, context);
            } else {
                if (!isDb) {
                    context.pushTarget();
                }
                this.traverse(propertyNode, context);
                if (!isDb) {
                    IDefinition def = propertyNode.getDefinition();
                    Name n = ((DefinitionBase)def).getMName(this.getProject());
                    context.addInstruction(97, n);
                }
            }
            context.stopUsing(IL.PROPERTIES, 1);
        }
    }

    public static boolean isDataBindingNode(IASNode node) {
        return node instanceof IMXMLDataBindingNode;
    }

    protected static boolean instanceAffectsBindings(IMXMLInstanceNode instanceNode) {
        int numChildren = instanceNode.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            IMXMLPropertySpecifierNode propertyNode;
            IASNode child = instanceNode.getChild(i);
            if (!(child instanceof IMXMLPropertySpecifierNode) || !MXMLClassDirectiveProcessor.isDataBindingNode((propertyNode = (IMXMLPropertySpecifierNode)child).getInstanceNode())) continue;
            return true;
        }
        return false;
    }

    protected static boolean isDataboundProp(IMXMLPropertySpecifierNode propertyNode) {
        boolean ret = propertyNode.getChildCount() > 0 && MXMLClassDirectiveProcessor.isDataBindingNode(propertyNode.getInstanceNode());
        int n = propertyNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            boolean db = MXMLClassDirectiveProcessor.isDataBindingNode(propertyNode.getChild(i));
            assert (db == ret);
        }
        return ret;
    }

    private void setFactoryStyle(IMXMLStyleSpecifierNode styleNode, Context context) {
        assert (!MXMLClassDirectiveProcessor.isDataBindingNode(styleNode.getInstanceNode()));
        String styleName = styleNode.getName();
        context.addInstruction(208);
        this.traverse(styleNode, context);
        context.addInstruction(97, new Name(styleName));
    }

    void processMXMLStyleSpecifier(IMXMLStyleSpecifierNode styleNode, Context context) {
        if (this.isStateDependent(styleNode)) {
            return;
        }
        IMXMLInstanceNode value = styleNode.getInstanceNode();
        if (MXMLClassDirectiveProcessor.isDataBindingNode(value)) {
            return;
        }
        if (styleNode.getParent() instanceof IMXMLClassDefinitionNode) {
            context.startUsing(IL.MODULE_FACTORY_STYLES);
            context.makingSimpleArray = true;
            this.setFactoryStyle(styleNode, context);
            context.makingSimpleArray = false;
            context.stopUsing(IL.MODULE_FACTORY_STYLES, 1);
            this.hasStyleSpecifiers = true;
        } else if (this.generateDescriptorCode(styleNode, context)) {
            if (!this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                context.startUsing(IL.DESCRIPTOR_STYLES);
                this.setFactoryStyle(styleNode, context);
                context.stopUsing(IL.DESCRIPTOR_STYLES, 1);
            } else {
                context.startUsing(IL.STYLES);
                String styleName = styleNode.getName();
                context.addInstruction(44, styleName);
                this.traverse(styleNode, context);
                context.stopUsing(IL.STYLES, 1);
            }
        } else if (this.generateNonDescriptorCode(styleNode, context)) {
            String styleName = styleNode.getName();
            context.startUsing(IL.STYLES);
            if (!this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                context.pushTarget();
                context.addInstruction(44, styleName);
                this.traverse(styleNode, context);
                context.addInstruction(79, IMXMLTypeConstants.SET_STYLE_CALL_OPERANDS);
            } else {
                context.addInstruction(44, styleName);
                this.traverse(styleNode, context);
            }
            context.stopUsing(IL.STYLES, 1);
        }
    }

    void processMXMLEffectSpecifier(IMXMLEffectSpecifierNode effectNode, Context context) {
        if (this.isStateDependent(effectNode)) {
            return;
        }
        IMXMLInstanceNode value = effectNode.getInstanceNode();
        if (MXMLClassDirectiveProcessor.isDataBindingNode(value)) {
            return;
        }
        String effectName = effectNode.getName();
        if (effectNode.getParent() instanceof IMXMLClassDefinitionNode) {
            context.startUsing(IL.MODULE_FACTORY_EFFECT_STYLES);
            this.setFactoryStyle(effectNode, context);
            context.stopUsing(IL.MODULE_FACTORY_EFFECT_STYLES, 1);
            context.startUsing(IL.MODULE_FACTORY_EFFECTS);
            context.addInstruction(44, effectName);
            context.stopUsing(IL.MODULE_FACTORY_EFFECTS, 1);
            this.hasEffectSpecifiers = true;
        } else if (this.generateDescriptorCode(effectNode, context)) {
            context.startUsing(IL.DESCRIPTOR_EFFECT_STYLES);
            this.setFactoryStyle(effectNode, context);
            context.stopUsing(IL.DESCRIPTOR_EFFECT_STYLES, 1);
            context.startUsing(IL.DESCRIPTOR_EFFECTS);
            context.addInstruction(44, effectName);
            context.stopUsing(IL.DESCRIPTOR_EFFECTS, 1);
        }
        if (this.generateNonDescriptorCode(effectNode, context)) {
            context.startUsing(IL.EFFECT_STYLES);
            context.pushTarget();
            context.addInstruction(44, effectName);
            this.traverse(effectNode, context);
            context.addInstruction(79, IMXMLTypeConstants.SET_STYLE_CALL_OPERANDS);
            context.stopUsing(IL.EFFECT_STYLES, 1);
            context.startUsing(IL.EFFECTS);
            context.addInstruction(44, effectName);
            context.stopUsing(IL.EFFECTS, 1);
        }
    }

    void processMXMLEventSpecifier(IMXMLEventSpecifierNode eventNode, Context context) {
        Name name = this.getEventHandlerName(eventNode);
        MethodInfo methodInfo = MXMLClassDirectiveProcessor.createEventHandlerMethodInfo(this.getProject(), eventNode, name.getBaseName());
        this.addMethodTrait(name, methodInfo, false);
        this.classScope.getGenerator().generateMethodBodyForFunction(methodInfo, eventNode, this.classScope, null);
        if (this.isStateDependent(eventNode)) {
            return;
        }
        String eventName = eventNode.getName();
        Name eventHandler = this.getEventHandlerName(eventNode);
        if (this.generateDescriptorCode(eventNode, context)) {
            if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                context.startUsing(IL.EVENTS);
                context.addInstruction(44, eventName);
                context.addInstruction(208);
                context.addInstruction(102, eventHandler);
                context.stopUsing(IL.EVENTS, 1);
            } else {
                context.startUsing(IL.DESCRIPTOR_EVENTS);
                context.addInstruction(44, eventName);
                context.addInstruction(44, eventHandler.getBaseName());
                context.stopUsing(IL.DESCRIPTOR_EVENTS, 1);
            }
        }
        if (this.generateNonDescriptorCode(eventNode, context)) {
            context.startUsing(IL.EVENTS);
            if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                context.addInstruction(44, eventName);
                context.addInstruction(208);
                context.addInstruction(102, eventHandler);
            } else {
                context.pushTarget();
                context.addInstruction(44, eventName);
                context.addInstruction(208);
                context.addInstruction(102, eventHandler);
                context.addInstruction(79, IMXMLTypeConstants.ADD_EVENT_LISTENER_CALL_OPERANDS);
            }
            context.stopUsing(IL.EVENTS, 1);
        }
    }

    void processMXMLDeclarations(IMXMLDeclarationsNode declarationsNode, Context context) {
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.startUsing(IL.MXML_CONTENT_FACTORY);
            context.isContentFactory = true;
            this.traverse(declarationsNode, context);
            context.isContentFactory = false;
            context.stopUsing(IL.MXML_CONTENT_FACTORY, 0);
        } else {
            this.traverse(declarationsNode, context);
        }
    }

    void processMXMLScript(IMXMLScriptNode scriptNode, Context context) {
        this.traverse(scriptNode, context);
    }

    void processMXMLMetadata(IMXMLMetadataNode metadataNode, Context context) {
    }

    void processMXMLResource(IMXMLResourceNode node, Context context) {
        ITypeDefinition type = node.getType();
        FlexProject project = this.getProject();
        try {
            String bundleName = node.getBundleName();
            String key = node.getKey();
            if (bundleName != null && key != null) {
                ICompilationUnit refCompUnit = project.getScope().getCompilationUnitForScope(((NodeBase)((Object)node)).getASScope());
                assert (refCompUnit != null);
                ResourceBundleUtils.resolveDependencies(bundleName, refCompUnit, project, node, this.getProblems());
            }
        }
        catch (InterruptedException ie) {
            throw new CodegenInterruptedException(ie);
        }
        String methodName = null;
        methodName = type.isInstanceOf(project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING), (ICompilerProject)project) ? "getString" : (type.isInstanceOf(project.getBuiltinType(IASLanguageConstants.BuiltinType.BOOLEAN), (ICompilerProject)project) ? "getBoolean" : (type.isInstanceOf(project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER), (ICompilerProject)project) ? "getNumber" : (type.isInstanceOf(project.getBuiltinType(IASLanguageConstants.BuiltinType.INT), (ICompilerProject)project) ? "getInt" : (type.isInstanceOf(project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT).resolveType(project), (ICompilerProject)project) ? "getUint" : (type.isInstanceOf(project.getBuiltinType(IASLanguageConstants.BuiltinType.CLASS), (ICompilerProject)project) ? "getClass" : (type.isInstanceOf(project.getBuiltinType(IASLanguageConstants.BuiltinType.ARRAY), (ICompilerProject)project) ? "getStringArray" : "getObject"))))));
        Name resourceManagerName = project.getResourceManagerClassName();
        context.addInstruction(96, resourceManagerName);
        context.addInstruction(70, IMXMLTypeConstants.GET_INSTANCE_CALL_OPERANDS);
        context.addInstruction(44, node.getBundleName());
        context.addInstruction(44, node.getKey());
        context.addInstruction(70, new Object[]{new Name(methodName), 2});
    }

    void processMXMLStyle(IMXMLStyleNode styleNode, Context context) {
        HashSet<ICompilerProblem> problems = new HashSet<ICompilerProblem>();
        ICSSDocument css = styleNode.getCSSDocument(problems);
        if (css == CSSDocumentCache.EMPTY_CSS_DOCUMENT) {
            return;
        }
        FlexProject flexProject = this.getProject();
        CSSCompilationSession session = styleNode.getFileNode().getCSSCompilationSession();
        if (session == null) {
            return;
        }
        CSSReducer reducer = new CSSReducer(flexProject, css, this.emitter, session, false, this.styleTagIndex);
        CSSEmitter emitter = new CSSEmitter(reducer);
        try {
            emitter.burm(css);
        }
        catch (Exception e) {
            problems.add(new CSSCodeGenProblem(e));
        }
        this.getProblems().addAll(problems);
        if (this.styleTagIndex == 0) {
            reducer.visitClassTraits(this.ctraits);
        }
        this.cinitInsns.addAll(reducer.getClassInitializationInstructions());
        ++this.styleTagIndex;
    }

    void processMXMLState(IMXMLStateNode stateNode, Context context) {
        IMXMLClassDefinitionNode classDefinitionNode;
        List<IMXMLNode> nodes;
        int numElements = 1;
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.isStateDescriptor = true;
        }
        this.processMXMLInstance(stateNode, context);
        String name = stateNode.getStateName();
        if (name != null) {
            if (!this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                context.addInstruction(42);
                context.addInstruction(44, name);
                context.addInstruction(97, IMXMLTypeConstants.NAME_NAME);
            } else {
                context.startUsing(IL.PROPERTIES);
                context.addInstruction(44, "name");
                context.addInstruction(38);
                context.addInstruction(44, name);
                context.stopUsing(IL.PROPERTIES, 1);
            }
        }
        if ((nodes = (classDefinitionNode = stateNode.getClassDefinitionNode()).getNodesDependentOnState(stateNode.getStateName())) != null) {
            if (!this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                context.addInstruction(42);
            } else {
                context.startUsing(IL.PROPERTIES);
                context.addInstruction(44, "overrides");
                context.addInstruction(32);
            }
            for (int i = nodes.size() - 1; i >= 0; --i) {
                IMXMLNode node = nodes.get(i);
                if (node.getNodeID() != ASTNodeID.MXMLInstanceID) continue;
                this.processInstanceOverride((IMXMLInstanceNode)node, context);
            }
            for (IMXMLNode node : nodes) {
                switch (node.getNodeID()) {
                    case MXMLPropertySpecifierID: {
                        this.processPropertyOverride((IMXMLPropertySpecifierNode)node, context);
                        break;
                    }
                    case MXMLStyleSpecifierID: {
                        this.processStyleOverride((IMXMLStyleSpecifierNode)node, context);
                        break;
                    }
                    case MXMLEventSpecifierID: {
                        this.processEventOverride((IMXMLEventSpecifierNode)node, context);
                    }
                }
            }
            if (!this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                context.addInstruction(86, nodes.size());
                context.addInstruction(97, IMXMLTypeConstants.NAME_OVERRIDES);
            } else {
                context.addInstruction(86, context.getCounter(IL.MXML_OVERRIDE_PROPERTIES));
                context.stopUsing(IL.PROPERTIES, 1);
                context.parentContext.incrementCounter(IL.MXML_STATES_ARRAY, numElements += this.setSpecifiers(context, true, false));
            }
        } else if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.parentContext.incrementCounter(IL.MXML_STATES_ARRAY, numElements += this.setSpecifiers(context, true, false));
        }
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.isStateDescriptor = false;
        }
    }

    void processPropertyOverride(IMXMLPropertySpecifierNode propertyNode, Context context) {
        FlexProject project = this.getProject();
        Name propertyOverride = project.getPropertyOverrideClassName();
        this.processPropertyOrStyleOverride(propertyOverride, propertyNode, context);
    }

    void processStyleOverride(IMXMLStyleSpecifierNode styleNode, Context context) {
        FlexProject project = this.getProject();
        Name styleOverride = project.getStyleOverrideClassName();
        this.processPropertyOrStyleOverride(styleOverride, styleNode, context);
    }

    void processPropertyOrStyleOverride(Name overrideName, IMXMLPropertySpecifierNode propertyOrStyleNode, Context context) {
        IASNode parentNode = propertyOrStyleNode.getParent();
        String id = parentNode instanceof IMXMLInstanceNode ? ((IMXMLInstanceNode)parentNode).getEffectiveID() : "";
        String name = propertyOrStyleNode.getName();
        IMXMLInstanceNode propertyOrStyleValueNode = propertyOrStyleNode.getInstanceNode();
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.addInstruction(93, overrideName);
            context.addInstruction(102, overrideName);
            boolean valueIsDataBound = MXMLClassDirectiveProcessor.isDataBindingNode(propertyOrStyleNode.getChild(0));
            context.pushNumericConstant(3L);
            context.addInstruction(44, "target");
            context.addInstruction(38);
            if (id.length() == 0) {
                context.addInstruction(32);
            } else {
                context.addInstruction(44, id);
            }
            context.addInstruction(44, "name");
            context.addInstruction(38);
            context.addInstruction(44, name);
            if (!valueIsDataBound) {
                context.addInstruction(44, "value");
                this.processNode(propertyOrStyleValueNode, context);
            } else {
                String overrideID = BINDABLE_OVERRIDE_NAME_BASE + Integer.toString(this.bindableOverrideCounter++);
                context.addInstruction(44, "id");
                context.addInstruction(38);
                context.addInstruction(44, overrideID);
                this.addVariableTrait(new Name(overrideID), overrideName);
                BindingInfo bi = this.bindingDirectiveHelper.visitNode((IMXMLDataBindingNode)propertyOrStyleNode.getChild(0));
                bi.setDestinationString(overrideID + ".value");
            }
            context.pushNumericConstant(0L);
            context.pushNumericConstant(0L);
            context.pushNumericConstant(0L);
            context.addInstruction(32);
            context.incrementCounter(IL.MXML_OVERRIDE_PROPERTIES, 15);
        } else {
            context.addInstruction(93, overrideName);
            context.addInstruction(74, new Object[]{overrideName, 0});
            context.addInstruction(42);
            if (id.length() == 0) {
                context.addInstruction(32);
            } else {
                context.addInstruction(44, id);
            }
            context.addInstruction(97, IMXMLTypeConstants.NAME_TARGET);
            context.addInstruction(42);
            context.addInstruction(44, name);
            context.addInstruction(97, IMXMLTypeConstants.NAME_NAME);
            context.addInstruction(42);
            boolean valueIsDataBound = MXMLClassDirectiveProcessor.isDataBindingNode(propertyOrStyleNode.getChild(0));
            if (!valueIsDataBound) {
                this.processNode(propertyOrStyleValueNode, context);
            } else {
                context.addInstruction(33);
            }
            context.addInstruction(97, IMXMLTypeConstants.NAME_VALUE);
        }
    }

    void processEventOverride(IMXMLEventSpecifierNode eventNode, Context context) {
        FlexProject project = this.getProject();
        Name eventOverride = project.getEventOverrideClassName();
        IASNode parentNode = eventNode.getParent();
        String id = parentNode instanceof IMXMLInstanceNode ? ((IMXMLInstanceNode)parentNode).getEffectiveID() : "";
        String name = eventNode.getName();
        Name eventHandler = this.getEventHandlerName(eventNode);
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.addInstruction(93, eventOverride);
            context.addInstruction(102, eventOverride);
            boolean valueIsDataBound = MXMLClassDirectiveProcessor.isDataBindingNode(eventNode.getChild(0));
            context.pushNumericConstant(valueIsDataBound ? 2L : 3L);
            context.addInstruction(44, "target");
            context.addInstruction(38);
            if (id.length() == 0) {
                context.addInstruction(32);
            } else {
                context.addInstruction(44, id);
            }
            context.addInstruction(44, "name");
            context.addInstruction(38);
            context.addInstruction(44, name);
            if (!valueIsDataBound) {
                context.addInstruction(44, "handlerFunction");
                context.addInstruction(38);
                context.addInstruction(208);
                context.addInstruction(102, eventHandler);
            }
            context.pushNumericConstant(0L);
            context.pushNumericConstant(0L);
            context.pushNumericConstant(0L);
            context.addInstruction(32);
            context.incrementCounter(IL.MXML_OVERRIDE_PROPERTIES, valueIsDataBound ? 12 : 15);
        } else {
            context.addInstruction(93, eventOverride);
            context.addInstruction(74, new Object[]{eventOverride, 0});
            context.addInstruction(42);
            context.addInstruction(44, id);
            context.addInstruction(97, IMXMLTypeConstants.NAME_TARGET);
            context.addInstruction(42);
            context.addInstruction(44, name);
            context.addInstruction(97, IMXMLTypeConstants.NAME_NAME);
            context.addInstruction(42);
            context.addInstruction(208);
            context.addInstruction(102, eventHandler);
            context.addInstruction(97, IMXMLTypeConstants.NAME_HANDLER_FUNCTION);
        }
    }

    void processInstanceOverride(IMXMLInstanceNode instanceNode, Context context) {
        FlexProject project = this.getProject();
        Name instanceOverrideName = project.getInstanceOverrideClassName();
        assert (this.nodeToIndexMap != null);
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.addInstruction(93, instanceOverrideName);
            context.addInstruction(102, instanceOverrideName);
        } else {
            context.addInstruction(93, instanceOverrideName);
            context.addInstruction(74, new Object[]{instanceOverrideName, 0});
        }
        Integer index = this.nodeToIndexMap.get(instanceNode);
        assert (index != null);
        InstructionList addItemsIL = new InstructionList();
        int addItemsCounter = 0;
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            addItemsIL.addInstruction(44, "itemsDescriptorIndex");
            addItemsIL.addInstruction(38);
            addItemsIL.pushNumericConstant(index.intValue());
            ++addItemsCounter;
        } else {
            context.addInstruction(42);
            context.addInstruction(211);
            context.pushNumericConstant(index.intValue());
            context.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
            context.addInstruction(97, new Name("itemsFactory"));
        }
        IMXMLPropertySpecifierNode propertySpecifier = (IMXMLPropertySpecifierNode)instanceNode.getAncestorOfType(IMXMLPropertySpecifierNode.class);
        if (propertySpecifier == null) {
            assert (false);
        } else {
            IASNode parent = propertySpecifier.getParent();
            if (parent instanceof IMXMLInstanceNode) {
                IMXMLInstanceNode parentInstance = (IMXMLInstanceNode)parent;
                String parentId = parentInstance.getEffectiveID();
                assert (parentId != null);
                String propName = propertySpecifier.getName();
                if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                    addItemsIL.addInstruction(44, "destination");
                    addItemsIL.addInstruction(38);
                    addItemsIL.addInstruction(44, parentId);
                    addItemsIL.addInstruction(44, "propertyName");
                    addItemsIL.addInstruction(38);
                    addItemsIL.addInstruction(44, propName);
                    addItemsCounter += 2;
                } else {
                    context.addInstruction(42);
                    context.addInstruction(44, parentId);
                    context.addInstruction(97, new Name("destination"));
                    context.addInstruction(42);
                    context.addInstruction(44, propName);
                    context.addInstruction(97, new Name("propertyName"));
                }
            }
        }
        String positionPropertyValue = null;
        String relativeToPropertyValue = null;
        IASNode instanceParent = instanceNode.getParent();
        IASNode prevStatelessSibling = null;
        for (int i = 0; i < instanceParent.getChildCount(); ++i) {
            IASNode sib = instanceParent.getChild(i);
            if (!(sib instanceof IMXMLInstanceNode)) continue;
            if (sib == instanceNode) break;
            if (this.isStateDependent(sib)) continue;
            prevStatelessSibling = sib;
        }
        if (prevStatelessSibling == null) {
            positionPropertyValue = "first";
        } else {
            positionPropertyValue = "after";
            relativeToPropertyValue = ((IMXMLInstanceNode)prevStatelessSibling).getEffectiveID();
        }
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            addItemsIL.addInstruction(44, "position");
            addItemsIL.addInstruction(38);
            addItemsIL.addInstruction(44, positionPropertyValue);
            ++addItemsCounter;
        } else {
            context.addInstruction(42);
            context.addInstruction(44, positionPropertyValue);
            context.addInstruction(97, new Name("position"));
        }
        if (relativeToPropertyValue != null) {
            if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
                addItemsIL.addInstruction(44, "relativeTo");
                addItemsIL.addInstruction(38);
                addItemsIL.addInstruction(44, relativeToPropertyValue);
                ++addItemsCounter;
            } else {
                context.addInstruction(42);
                context.addInstruction(44, relativeToPropertyValue);
                context.addInstruction(97, new Name("relativeTo"));
            }
        }
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.pushNumericConstant(addItemsCounter);
            context.addAll(addItemsIL);
            context.pushNumericConstant(0L);
            context.pushNumericConstant(0L);
            context.pushNumericConstant(0L);
            context.addInstruction(32);
            context.incrementCounter(IL.MXML_OVERRIDE_PROPERTIES, addItemsCounter * 3 + 6);
        }
    }

    void processMXMLDataBinding(IMXMLSingleDataBindingNode node, Context context) {
        this.bindingDirectiveHelper.visitNode(node);
    }

    void processMXMLConcatenatedDataBinding(IMXMLConcatenatedDataBindingNode node, Context context) {
        this.bindingDirectiveHelper.visitNode(node);
    }

    void processMXMLBinding(IMXMLBindingNode node, Context context) {
        this.bindingDirectiveHelper.visitNode(node);
    }

    void processMXMLRepeater(IMXMLRepeaterNode node, Context context) {
    }

    void processMXMLImplements(IMXMLImplementsNode node, Context context) {
    }

    void processMXMLComponent(IMXMLComponentNode node, Context context) {
        boolean inDecl = false;
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData() && node.getParent() instanceof IMXMLDeclarationsNode) {
            inDecl = true;
            context = context.parentContext;
            context.startUsing(IL.PROPERTIES);
            context.addInstruction(44, node.getID());
        }
        ClassDefinition componentClass = (ClassDefinition)node.getContainedClassDefinition();
        ASScope classScope = componentClass.getContainedScope();
        IDefinition outerDocument = classScope.getPropertyFromDef(this.getProject(), componentClass, "outerDocument", false);
        assert (outerDocument != null) : "outerDocument should never be null, as always added";
        if (!outerDocument.isContingent()) {
            MXMLOuterDocumentAlreadyDeclaredProblem problem = new MXMLOuterDocumentAlreadyDeclaredProblem(outerDocument);
            this.getProblems().add(problem);
        }
        this.processMXMLFactory(node, context);
        context.addInstruction(42);
        context.addInstruction(44, "outerDocument");
        context.addInstruction(208);
        context.addInstruction(85, 1);
        context.addInstruction(97, IMXMLTypeConstants.NAME_PROPERTIES);
        if (inDecl) {
            context.stopUsing(IL.PROPERTIES, 1);
        }
    }

    void processMXMLLibrary(IMXMLLibraryNode node, Context context) {
        this.traverse(node, context);
    }

    void processMXMLDefinition(IMXMLDefinitionNode node, Context context) {
        this.traverse(node, context);
    }

    protected void processMXMLClassDefinition(IMXMLClassDefinitionNode node, Context context) {
        MXMLClassDirectiveProcessor dp = new MXMLClassDirectiveProcessor(node, this.globalScope, this.emitter);
        dp.processMainClassDefinitionNode(node);
        dp.finishClassDefinition();
        ClassDefinition classDefinition = (ClassDefinition)node.getClassDefinition();
        FlexProject project = this.getProject();
        Name className = classDefinition.getMName(project);
        context.addInstruction(96, className);
    }

    void processMXMLEmbed(IMXMLEmbedNode node, Context context) {
        Name className;
        FlexProject project = this.getProject();
        ClassDefinition classDefinition = (ClassDefinition)node.getClassReference(project);
        Name name = className = classDefinition != null ? classDefinition.getMName(project) : null;
        if (this.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            context.addInstruction(38);
        }
        context.addInstruction(96, className);
    }

    void processMXMLXML(IMXMLXMLNode node, Context context) {
        String xmlString = node.getXMLString();
        if (xmlString == null) {
            context.addInstruction(32);
        } else if (node.getXMLType() == IMXMLXMLNode.XML_TYPE.E4X) {
            context.addInstruction(93, ABCGeneratingReducer.xmlType);
            context.addInstruction(44, xmlString);
            context.addInstruction(74, new Object[]{ABCGeneratingReducer.xmlType, 1});
        } else if (node.getXMLType() == IMXMLXMLNode.XML_TYPE.OLDXML) {
            FlexProject flexProject = this.getProject();
            context.addInstruction(96, flexProject.getXMLUtilClassName());
            context.addInstruction(44, node.getXMLString());
            context.addInstruction(70, IMXMLTypeConstants.CREATE_XML_DOCUMENT_CALL_OPERANDS);
            context.addInstruction(102, new Name("firstChild"));
        }
        this.traverse(node, context);
    }

    void processMXMLXMLList(IMXMLXMLListNode node, Context context) {
        context.addInstruction(93, ABCGeneratingReducer.xmlListType);
        context.addInstruction(44, node.getXMLString());
        context.addInstruction(74, MXMLClassDirectiveProcessor.CONSTRUCT_XML_LIST_OPERANDS);
    }

    void processMXMLModel(IMXMLModelNode node, Context context) {
        this.pushModelClass(context);
        this.traverse(node, context);
    }

    private void pushModelClass(Context context) {
        FlexProject project = this.getProject();
        Name modelClassName = project.getModelClassName();
        context.addInstruction(93, modelClassName);
        context.addInstruction(74, new Object[]{modelClassName, 0});
    }

    void processMXMLModelRoot(IMXMLModelRootNode node, Context context) {
        this.setModelProperties(node, context);
    }

    private void setModelProperties(IMXMLModelPropertyContainerNode node, Context context) {
        for (String propertyName : node.getPropertyNames()) {
            context.pushTarget();
            this.pushModelPropertyValue(node, propertyName, context);
            context.addInstruction(97, new Name(propertyName));
        }
    }

    private void pushModelPropertyValue(IMXMLModelPropertyContainerNode node, String propertyName, Context context) {
        IMXMLModelPropertyNode[] childNodes = node.getPropertyNodes(propertyName);
        int n = childNodes.length;
        if (n > 1) {
            for (IMXMLModelPropertyNode childNode : childNodes) {
                this.processMXMLModelProperty(childNode, context);
            }
            context.addInstruction(86, n);
        } else if (n == 1) {
            this.processMXMLModelProperty(childNodes[0], context);
        }
    }

    void processMXMLModelProperty(IMXMLModelPropertyNode node, Context context) {
        if (node.hasLeafValue()) {
            if (MXMLClassDirectiveProcessor.isDataBindingNode(node.getInstanceNode())) {
                context.addInstruction(32);
                this.traverse(node, context);
            } else {
                this.traverse(node, context);
            }
        } else {
            this.pushModelClass(context);
            this.setModelProperties(node, context);
        }
    }

    void processMXMLPrivate(IMXMLPrivateNode node, Context context) {
    }

    void processMXMLClear(IMXMLClearNode node, Context context) {
    }

    void processMXMLReparent(IMXMLReparentNode node, Context context) {
    }

    private void generateStylesAndEffects(Context context) {
        FlexProject project;
        String flexModuleInterface;
        if ((this.hasStyleSpecifiers || this.hasEffectSpecifiers || this.styleTagIndex > 0) && this.classDefinition.isInstanceOf(flexModuleInterface = (project = this.getProject()).getFlexModuleInterface(), (ICompilerProject)project)) {
            this.addVariableTrait(NAME_MODULE_FACTORY_INITIALIZED, IMXMLTypeConstants.NAME_BOOLEAN);
            this.overrideModuleFactorySetter(context);
        }
    }

    private void overrideModuleFactorySetter(Context context) {
        Name moduleFactoryName = new Name("moduleFactory");
        IResolvedQualifiersReference styleManagerReference = ReferenceFactory.packageQualifiedReference(this.getProject().getWorkspace(), "mx.styles.StyleManagerImpl");
        Name styleManagerReferenceName = styleManagerReference.getMName();
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setMethodName("moduleFactory");
        methodInfo.setReturnType(IMXMLTypeConstants.NAME_VOID);
        methodInfo.setParamNames((List<String>)ImmutableList.of((Object)"factory"));
        Vector<Name> paramTypes = new Vector<Name>();
        Name flexModuleFactoryTypeName = new Name(new Namespace(22, "mx.core"), "IFlexModuleFactory");
        paramTypes.add(flexModuleFactoryTypeName);
        methodInfo.setParamTypes(paramTypes);
        InstructionList methodInstructions = new InstructionList();
        methodInstructions.addInstruction(208);
        methodInstructions.addInstruction(209);
        methodInstructions.addInstruction(5, moduleFactoryName);
        Label label1 = new Label();
        methodInstructions.addInstruction(208);
        methodInstructions.addInstruction(102, NAME_MODULE_FACTORY_INITIALIZED);
        methodInstructions.addInstruction(18, label1);
        methodInstructions.addInstruction(71);
        methodInstructions.labelNext(label1);
        methodInstructions.addInstruction(208);
        methodInstructions.addInstruction(38);
        methodInstructions.addInstruction(97, NAME_MODULE_FACTORY_INITIALIZED);
        if (this.hasStyleSpecifiers || this.hasEffectSpecifiers) {
            FlexProject project = this.getProject();
            Name cssStyleDeclarationName = project.getCSSStyleDeclarationClassName();
            MethodInfo styleDeclarationDefaultFactory = this.createStyleDeclarationDefaultFactory(context);
            Label label2 = new Label();
            methodInstructions.addInstruction(208);
            methodInstructions.addInstruction(102, IMXMLTypeConstants.NAME_STYLE_DECLARATION);
            methodInstructions.addInstruction(17, label2);
            methodInstructions.addInstruction(208);
            methodInstructions.addInstruction(93, cssStyleDeclarationName);
            methodInstructions.addInstruction(32);
            methodInstructions.addInstruction(208);
            methodInstructions.addInstruction(102, IMXMLTypeConstants.NAME_STYLE_MANAGER);
            methodInstructions.addInstruction(74, new Object[]{cssStyleDeclarationName, 2});
            methodInstructions.addInstruction(97, IMXMLTypeConstants.NAME_STYLE_DECLARATION);
            methodInstructions.labelNext(label2);
            methodInstructions.addInstruction(208);
            methodInstructions.addInstruction(102, IMXMLTypeConstants.NAME_STYLE_DECLARATION);
            methodInstructions.addInstruction(64, styleDeclarationDefaultFactory);
            methodInstructions.addInstruction(97, IMXMLTypeConstants.NAME_DEFAULT_FACTORY);
        }
        if (this.hasEffectSpecifiers) {
            methodInstructions.addInstruction(208);
            methodInstructions.addAll(context.get(IL.MODULE_FACTORY_EFFECTS));
            methodInstructions.addInstruction(86, context.getCounter(IL.MODULE_FACTORY_EFFECTS));
            methodInstructions.addInstruction(79, IMXMLTypeConstants.REGISTER_EFFECTS_CALL_OPERANDS);
        }
        if (this.styleTagIndex > 0) {
            methodInstructions.addInstruction(96, styleManagerReferenceName);
            methodInstructions.addInstruction(208);
            methodInstructions.addInstruction(4, IMXMLTypeConstants.NAME_STYLE_MANAGER);
            methodInstructions.addInstruction(96, CSSReducer.NAME_FACTORY_FUNCTIONS);
            methodInstructions.addInstruction(96, CSSReducer.NAME_DATA_ARRAY);
            methodInstructions.addInstruction(70, new Object[]{NAME_GENERATE_CSSSTYLEDECLARATIONS, 3});
            if (this.styleTagIndex > 1) {
                for (int i = 1; i < this.styleTagIndex; ++i) {
                    methodInstructions.addInstruction(96, styleManagerReferenceName);
                    methodInstructions.addInstruction(208);
                    methodInstructions.addInstruction(4, IMXMLTypeConstants.NAME_STYLE_MANAGER);
                    methodInstructions.addInstruction(96, new Name("factoryFunctions" + Integer.toString(i)));
                    methodInstructions.addInstruction(96, new Name(CSSReducer.NAME_DATA_ARRAY + Integer.toString(i)));
                    methodInstructions.addInstruction(70, new Object[]{NAME_GENERATE_CSSSTYLEDECLARATIONS, 3});
                }
            }
        }
        methodInstructions.addInstruction(208);
        methodInstructions.addInstruction(4, IMXMLTypeConstants.NAME_STYLE_MANAGER);
        methodInstructions.addInstruction(79, new Object[]{new Name("initProtoChainRoots"), 0});
        methodInstructions.addInstruction(71);
        this.generateMethodBody(methodInfo, this.classScope, methodInstructions);
        this.addSetter(moduleFactoryName, methodInfo, true);
    }

    private MethodInfo createStyleDeclarationDefaultFactory(Context context) {
        InstructionList body = new InstructionList();
        body.addAll(context.get(IL.MODULE_FACTORY_STYLES));
        body.addAll(context.get(IL.MODULE_FACTORY_EFFECT_STYLES));
        body.addInstruction(71);
        return this.createNoParameterAnonymousFunction(IMXMLTypeConstants.NAME_VOID, body);
    }

    static enum IL {
        PROPERTIES,
        EVENTS,
        STYLES,
        EFFECT_STYLES,
        EFFECTS,
        DESCRIPTOR,
        DESCRIPTOR_PROPERTIES,
        DESCRIPTOR_EVENTS,
        DESCRIPTOR_STYLES,
        DESCRIPTOR_EFFECT_STYLES,
        DESCRIPTOR_EFFECTS,
        DESCRIPTOR_CHILD_DESCRIPTORS,
        MODULE_FACTORY_STYLES,
        MODULE_FACTORY_EFFECT_STYLES,
        MODULE_FACTORY_EFFECTS,
        WEB_SERVICE_OPERATIONS_OR_REMOTE_OBJECT_METHODS,
        MXML_CONTENT_FACTORY,
        MXML_STATES_ARRAY,
        MXML_OVERRIDE_PROPERTIES,
        MXML_ADD_ITEMS_PROPERTIES,
        MXML_MODEL_PROPERTIES,
        MXML_BEAD_PROPERTIES;

    }

    static class Context {
        private final IMXMLClassReferenceNode node;
        private InstructionList mainInstructionList;
        private InstructionList currentInstructionList;
        private boolean nonPublic = false;
        private boolean needsDescriptor = false;
        private Map<IL, InstructionList> instructionListMap;
        private Deque<InstructionList> instructionListDeque;
        private Map<IL, Integer> counterMap;
        Name instanceClassName;
        private boolean instanceHasOwnInitializer;
        boolean isContentFactory;
        boolean hasModel;
        boolean hasBeads;
        boolean makingSimpleArray;
        boolean makingArrayValues;
        int numArrayValues = 0;
        boolean isStateDescriptor;
        Context parentContext;
        protected int pushTargetOpcode;

        private Context(IMXMLClassDefinitionNode classDefinitionNode, InstructionList instructionList) {
            this((IMXMLClassReferenceNode)classDefinitionNode, instructionList, 208);
        }

        private Context(IMXMLInstanceNode instanceNode, InstructionList instructionList) {
            this((IMXMLClassReferenceNode)instanceNode, instructionList, 42);
        }

        private Context(IMXMLClassReferenceNode node, InstructionList instructionList, int pushTargetOpcode) {
            this.node = node;
            this.currentInstructionList = this.mainInstructionList = instructionList;
            this.pushTargetOpcode = pushTargetOpcode;
            this.needsDescriptor = node.needsDescriptor();
        }

        private void pushTarget() {
            this.addInstruction(this.pushTargetOpcode);
        }

        private void addInstruction(int opcode) {
            this.currentInstructionList.addInstruction(opcode);
        }

        private void addInstruction(int opcode, int immed) {
            this.currentInstructionList.addInstruction(opcode, immed);
        }

        private void addInstruction(int opcode, Object operand) {
            this.currentInstructionList.addInstruction(opcode, operand);
        }

        private void addInstruction(int opcode, Object[] operands) {
            this.currentInstructionList.addInstruction(opcode, operands);
        }

        private void addAll(InstructionList sourceInstructionList) {
            if (sourceInstructionList != null) {
                this.currentInstructionList.addAll(sourceInstructionList);
            }
        }

        private void labelNext(Label label) {
            this.currentInstructionList.labelNext(label);
        }

        private void pushNumericConstant(long value) {
            this.currentInstructionList.pushNumericConstant(value);
        }

        private InstructionList get(IL whichList) {
            InstructionList instructionList;
            if (this.instructionListMap == null) {
                this.instructionListMap = new EnumMap<IL, InstructionList>(IL.class);
            }
            if ((instructionList = this.instructionListMap.get((Object)whichList)) == null) {
                instructionList = new InstructionList();
                this.instructionListMap.put(whichList, instructionList);
            }
            return instructionList;
        }

        void startUsing(IL whichList) {
            InstructionList instructionListToUse = this.get(whichList);
            if (this.instructionListDeque == null) {
                this.instructionListDeque = new ArrayDeque<InstructionList>();
            }
            this.instructionListDeque.push(this.currentInstructionList);
            this.currentInstructionList = instructionListToUse;
        }

        private void stopUsing(IL whichList, int delta) {
            assert (this.get(whichList) == this.currentInstructionList);
            this.currentInstructionList = this.instructionListDeque.pop();
            this.incrementCounter(whichList, delta);
        }

        private void transfer(IL source, IL destination) {
            InstructionList sourceInstructionList = this.get(source);
            InstructionList destinationInstructionList = this.get(destination);
            destinationInstructionList.addAll(sourceInstructionList);
            this.remove(source);
        }

        private void transfer(IL source) {
            InstructionList sourceInstructionList = this.get(source);
            this.currentInstructionList.addAll(sourceInstructionList);
            this.remove(source);
        }

        private void remove(IL whichList) {
            this.instructionListMap.remove((Object)whichList);
        }

        private int getCounter(IL whichList) {
            Integer counter;
            if (this.counterMap == null) {
                this.counterMap = new EnumMap<IL, Integer>(IL.class);
            }
            return (counter = this.counterMap.get((Object)whichList)) != null ? counter : 0;
        }

        private void incrementCounter(IL whichList, int amount) {
            int n = this.getCounter(whichList);
            this.counterMap.put(whichList, n + amount);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("MAIN:\n");
            sb.append(this.mainInstructionList.toString());
            if (this.instructionListMap != null) {
                for (IL whichList : IL.values()) {
                    if (!this.instructionListMap.containsKey((Object)whichList)) continue;
                    sb.append('\n');
                    sb.append(whichList.name());
                    sb.append('\n');
                    sb.append(this.get(whichList).toString());
                }
            }
            return sb.toString();
        }

        private void callTrace(String message) {
            Name trace = new Name("trace");
            this.addInstruction(208);
            this.addInstruction(48);
            this.addInstruction(93, trace);
            this.addInstruction(44, message);
            this.addInstruction(79, new Object[]{trace, 1});
            this.addInstruction(29);
        }

        private void trace(String message) {
            this.callTrace(message);
        }
    }
}

