/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.SubscriptionPattern;
import org.apache.kafka.clients.consumer.internals.AbstractHeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.AbstractMembershipManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMembershipManager;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.metrics.HeartbeatMetricsManager;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;

public class ConsumerHeartbeatRequestManager
extends AbstractHeartbeatRequestManager<ConsumerGroupHeartbeatResponse> {
    private final ConsumerMembershipManager membershipManager;
    private final HeartbeatState heartbeatState;

    public ConsumerHeartbeatRequestManager(LogContext logContext, Time time, ConsumerConfig config, CoordinatorRequestManager coordinatorRequestManager, SubscriptionState subscriptions, ConsumerMembershipManager membershipManager, BackgroundEventHandler backgroundEventHandler, Metrics metrics) {
        super(logContext, time, config, coordinatorRequestManager, backgroundEventHandler, new HeartbeatMetricsManager(metrics));
        this.membershipManager = membershipManager;
        this.heartbeatState = new HeartbeatState(subscriptions, membershipManager, this.maxPollIntervalMs);
    }

    ConsumerHeartbeatRequestManager(LogContext logContext, Timer timer, ConsumerConfig config, CoordinatorRequestManager coordinatorRequestManager, ConsumerMembershipManager membershipManager, HeartbeatState heartbeatState, AbstractHeartbeatRequestManager.HeartbeatRequestState heartbeatRequestState, BackgroundEventHandler backgroundEventHandler, Metrics metrics) {
        super(logContext, timer, config, coordinatorRequestManager, heartbeatRequestState, backgroundEventHandler, new HeartbeatMetricsManager(metrics));
        this.membershipManager = membershipManager;
        this.heartbeatState = heartbeatState;
    }

    @Override
    public boolean handleSpecificError(ConsumerGroupHeartbeatResponse response, long currentTimeMs) {
        boolean errorHandled;
        Errors error = this.errorForResponse(response);
        String errorMessage = this.errorMessageForResponse(response);
        switch (error) {
            case UNRELEASED_INSTANCE_ID: {
                this.logger.error("{} failed due to unreleased instance id {}: {}", this.heartbeatRequestName(), this.membershipManager.groupInstanceId().orElse("null"), errorMessage);
                this.handleFatalFailure(error.exception(errorMessage));
                errorHandled = true;
                break;
            }
            case FENCED_INSTANCE_ID: {
                this.logger.error("{} failed due to fenced instance id {}: {}. This is expected in the case that the member was removed from the group by an admin client, and another member joined using the same group instance id.", this.heartbeatRequestName(), this.membershipManager.groupInstanceId().orElse("null"), errorMessage);
                this.handleFatalFailure(error.exception(errorMessage));
                errorHandled = true;
                break;
            }
            default: {
                errorHandled = false;
            }
        }
        return errorHandled;
    }

    @Override
    public void resetHeartbeatState() {
        this.heartbeatState.reset();
    }

    @Override
    public NetworkClientDelegate.UnsentRequest buildHeartbeatRequest() {
        return new NetworkClientDelegate.UnsentRequest(new ConsumerGroupHeartbeatRequest.Builder(this.heartbeatState.buildRequestData()), this.coordinatorRequestManager.coordinator());
    }

    @Override
    public String heartbeatRequestName() {
        return "ConsumerGroupHeartbeatRequest";
    }

    @Override
    public Errors errorForResponse(ConsumerGroupHeartbeatResponse response) {
        return Errors.forCode(response.data().errorCode());
    }

    @Override
    public String errorMessageForResponse(ConsumerGroupHeartbeatResponse response) {
        return response.data().errorMessage();
    }

    @Override
    public long heartbeatIntervalForResponse(ConsumerGroupHeartbeatResponse response) {
        return response.data().heartbeatIntervalMs();
    }

    public ConsumerMembershipManager membershipManager() {
        return this.membershipManager;
    }

    static class HeartbeatState {
        private final SubscriptionState subscriptions;
        private final ConsumerMembershipManager membershipManager;
        private final int rebalanceTimeoutMs;
        private final SentFields sentFields;

        public HeartbeatState(SubscriptionState subscriptions, ConsumerMembershipManager membershipManager, int rebalanceTimeoutMs) {
            this.subscriptions = subscriptions;
            this.membershipManager = membershipManager;
            this.rebalanceTimeoutMs = rebalanceTimeoutMs;
            this.sentFields = new SentFields();
        }

        public void reset() {
            this.sentFields.reset();
        }

        public ConsumerGroupHeartbeatRequestData buildRequestData() {
            SubscriptionPattern pattern;
            boolean patternUpdated;
            boolean sendAllFields;
            ConsumerGroupHeartbeatRequestData data = new ConsumerGroupHeartbeatRequestData();
            data.setGroupId(this.membershipManager.groupId());
            data.setMemberId(this.membershipManager.memberId());
            data.setMemberEpoch(this.membershipManager.memberEpoch());
            this.membershipManager.groupInstanceId().ifPresent(data::setInstanceId);
            boolean bl = sendAllFields = this.membershipManager.state() == MemberState.JOINING;
            if (sendAllFields || this.sentFields.rebalanceTimeoutMs != this.rebalanceTimeoutMs) {
                data.setRebalanceTimeoutMs(this.rebalanceTimeoutMs);
                this.sentFields.rebalanceTimeoutMs = this.rebalanceTimeoutMs;
            }
            TreeSet<String> subscribedTopicNames = new TreeSet<String>(this.subscriptions.subscription());
            if (sendAllFields || !subscribedTopicNames.equals(this.sentFields.subscribedTopicNames)) {
                data.setSubscribedTopicNames(new ArrayList<String>(this.subscriptions.subscription()));
                this.sentFields.subscribedTopicNames = subscribedTopicNames;
            }
            boolean bl2 = patternUpdated = !Objects.equals(pattern = this.subscriptions.subscriptionPattern(), this.sentFields.pattern);
            if (sendAllFields && pattern != null || patternUpdated) {
                data.setSubscribedTopicRegex(pattern != null ? pattern.pattern() : "");
                this.sentFields.pattern = pattern;
            }
            this.membershipManager.serverAssignor().ifPresent(serverAssignor -> {
                if (sendAllFields || !serverAssignor.equals(this.sentFields.serverAssignor)) {
                    data.setServerAssignor((String)serverAssignor);
                    this.sentFields.serverAssignor = serverAssignor;
                }
            });
            AbstractMembershipManager.LocalAssignment local = this.membershipManager.currentAssignment();
            if (sendAllFields || !local.equals(this.sentFields.localAssignment)) {
                List<ConsumerGroupHeartbeatRequestData.TopicPartitions> topicPartitions = this.buildTopicPartitionsList(local.partitions);
                data.setTopicPartitions(topicPartitions);
                this.sentFields.localAssignment = local;
            }
            return data;
        }

        private List<ConsumerGroupHeartbeatRequestData.TopicPartitions> buildTopicPartitionsList(Map<Uuid, SortedSet<Integer>> topicIdPartitions) {
            return topicIdPartitions.entrySet().stream().map(entry -> new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId((Uuid)entry.getKey()).setPartitions(new ArrayList<Integer>((Collection)entry.getValue()))).collect(Collectors.toList());
        }

        static class SentFields {
            private int rebalanceTimeoutMs = -1;
            private TreeSet<String> subscribedTopicNames = null;
            private SubscriptionPattern pattern = null;
            private String serverAssignor = null;
            private AbstractMembershipManager.LocalAssignment localAssignment = null;

            SentFields() {
            }

            void reset() {
                this.subscribedTopicNames = null;
                this.rebalanceTimeoutMs = -1;
                this.serverAssignor = null;
                this.localAssignment = null;
                this.pattern = null;
            }
        }
    }
}

