/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.registration;

import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TaskExecutorMemoryConfiguration;
import org.apache.flink.util.Preconditions;

public class WorkerRegistration<WorkerType extends ResourceIDRetrievable>
extends TaskExecutorConnection {
    private final WorkerType worker;
    private final int dataPort;
    private final int jmxPort;
    private final HardwareDescription hardwareDescription;
    private final TaskExecutorMemoryConfiguration memoryConfiguration;
    private final ResourceProfile totalResourceProfile;
    private final ResourceProfile defaultSlotResourceProfile;

    public WorkerRegistration(TaskExecutorGateway taskExecutorGateway, WorkerType worker, int dataPort, int jmxPort, HardwareDescription hardwareDescription, TaskExecutorMemoryConfiguration memoryConfiguration, ResourceProfile totalResourceProfile, ResourceProfile defaultSlotResourceProfile) {
        super(worker.getResourceID(), taskExecutorGateway);
        this.worker = (ResourceIDRetrievable)Preconditions.checkNotNull(worker);
        this.dataPort = dataPort;
        this.jmxPort = jmxPort;
        this.hardwareDescription = Preconditions.checkNotNull(hardwareDescription);
        this.memoryConfiguration = Preconditions.checkNotNull(memoryConfiguration);
        this.totalResourceProfile = Preconditions.checkNotNull(totalResourceProfile);
        this.defaultSlotResourceProfile = Preconditions.checkNotNull(defaultSlotResourceProfile);
    }

    public WorkerType getWorker() {
        return this.worker;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public HardwareDescription getHardwareDescription() {
        return this.hardwareDescription;
    }

    public TaskExecutorMemoryConfiguration getMemoryConfiguration() {
        return this.memoryConfiguration;
    }

    public ResourceProfile getDefaultSlotResourceProfile() {
        return this.defaultSlotResourceProfile;
    }

    public ResourceProfile getTotalResourceProfile() {
        return this.totalResourceProfile;
    }
}

