/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.util.Preconditions;

public class FineGrainedTaskManagerSlot
implements TaskManagerSlotInformation {
    private final ResourceProfile resourceProfile;
    private final TaskExecutorConnection taskManagerConnection;
    private final AllocationID allocationId;
    private final JobID jobId;
    private SlotState state;

    public FineGrainedTaskManagerSlot(AllocationID allocationId, JobID jobId, ResourceProfile resourceProfile, TaskExecutorConnection taskManagerConnection, SlotState slotState) {
        this.resourceProfile = Preconditions.checkNotNull(resourceProfile);
        this.taskManagerConnection = Preconditions.checkNotNull(taskManagerConnection);
        this.allocationId = Preconditions.checkNotNull(allocationId);
        this.jobId = Preconditions.checkNotNull(jobId);
        this.state = Preconditions.checkNotNull(slotState);
        Preconditions.checkArgument(!slotState.equals((Object)SlotState.FREE), "The slot of fine-grained resource management should be dynamically created in allocation. Thus it should not in FREE state.");
    }

    @Override
    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    @Override
    public SlotState getState() {
        return this.state;
    }

    @Override
    public JobID getJobId() {
        return this.jobId;
    }

    @Override
    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    @Override
    public SlotID getSlotId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InstanceID getInstanceId() {
        return this.taskManagerConnection.getInstanceID();
    }

    @Override
    public TaskExecutorConnection getTaskManagerConnection() {
        return this.taskManagerConnection;
    }

    public void completeAllocation() {
        Preconditions.checkState(this.state == SlotState.PENDING, "In order to complete an allocation, the slot has to be allocated.");
        this.state = SlotState.ALLOCATED;
    }
}

