/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.writer;

import java.io.IOException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.writer.FileWriter;
import org.apache.flink.table.store.file.writer.Metric;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public abstract class BaseFileWriter<T, R>
implements FileWriter<T, R> {
    private final FileWriter.Factory<T, Metric> writerFactory;
    private final Path path;
    private FileWriter<T, Metric> writer = null;
    private Metric metric = null;
    private boolean closed = false;

    public BaseFileWriter(FileWriter.Factory<T, Metric> writerFactory, Path path) {
        this.writerFactory = writerFactory;
        this.path = path;
    }

    public Path path() {
        return this.path;
    }

    private void openCurrentWriter() throws IOException {
        this.writer = this.writerFactory.create(this.path);
    }

    @Override
    public void write(T row) throws IOException {
        if (this.writer == null) {
            this.openCurrentWriter();
        }
        this.writer.write(row);
    }

    @Override
    public long recordCount() {
        if (this.writer != null) {
            return this.writer.recordCount();
        }
        if (this.metric != null) {
            return this.metric.recordCount();
        }
        return 0L;
    }

    @Override
    public long length() throws IOException {
        if (this.writer != null) {
            return this.writer.length();
        }
        if (this.metric != null) {
            return this.metric.length();
        }
        return 0L;
    }

    protected abstract R createResult(Path var1, Metric var2) throws IOException;

    @Override
    public void abort() {
        IOUtils.closeQuietly(this);
        FileUtils.deleteOrWarn(this.path);
    }

    @Override
    public R result() throws IOException {
        Preconditions.checkState(this.closed, "Cannot access the file meta unless close this writer.");
        Preconditions.checkNotNull(this.metric, "Metric cannot be null.");
        return this.createResult(this.path, this.metric);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.writer != null) {
                this.writer.close();
                this.metric = this.writer.result();
                this.writer = null;
            }
            this.closed = true;
        }
    }
}

