/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;

@Internal
public class ArchivedExecutionConfig
implements Serializable {
    private static final long serialVersionUID = 2907040336948181163L;
    private final String executionMode;
    private final String restartStrategyDescription;
    private final int parallelism;
    private final int maxParallelism;
    private final boolean objectReuseEnabled;
    private final Map<String, String> globalJobParameters;

    public ArchivedExecutionConfig(ExecutionConfig ec) {
        this.executionMode = ec.getExecutionMode().name();
        this.restartStrategyDescription = ec.getRestartStrategy() != null ? ec.getRestartStrategy().getDescription() : "default";
        this.maxParallelism = ec.getMaxParallelism();
        this.parallelism = ec.getParallelism();
        this.objectReuseEnabled = ec.isObjectReuseEnabled();
        this.globalJobParameters = ec.getGlobalJobParameters() != null && ec.getGlobalJobParameters().toMap() != null ? ec.getGlobalJobParameters().toMap() : Collections.emptyMap();
    }

    public ArchivedExecutionConfig(String executionMode, String restartStrategyDescription, int maxParallelism, int parallelism, boolean objectReuseEnabled, Map<String, String> globalJobParameters) {
        this.executionMode = executionMode;
        this.restartStrategyDescription = restartStrategyDescription;
        this.maxParallelism = maxParallelism;
        this.parallelism = parallelism;
        this.objectReuseEnabled = objectReuseEnabled;
        this.globalJobParameters = globalJobParameters;
    }

    public String getExecutionMode() {
        return this.executionMode;
    }

    public String getRestartStrategyDescription() {
        return this.restartStrategyDescription;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public boolean getObjectReuseEnabled() {
        return this.objectReuseEnabled;
    }

    public Map<String, String> getGlobalJobParameters() {
        return this.globalJobParameters;
    }
}

