/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.reader;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class SimpleStreamFormat<T>
implements StreamFormat<T> {
    private static final long serialVersionUID = 1L;

    public abstract StreamFormat.Reader<T> createReader(Configuration var1, FSDataInputStream var2) throws IOException;

    @Override
    public abstract TypeInformation<T> getProducedType();

    @Override
    public final boolean isSplittable() {
        return false;
    }

    @Override
    public final StreamFormat.Reader<T> createReader(Configuration config, FSDataInputStream stream, long fileLen, long splitEnd) throws IOException {
        SimpleStreamFormat.checkNotSplit(fileLen, splitEnd);
        long streamPos = stream.getPos();
        Preconditions.checkArgument(streamPos == 0L, "SimpleStreamFormat is not splittable, but found non-zero stream position (%s)", streamPos);
        return this.createReader(config, stream);
    }

    @Override
    public final StreamFormat.Reader<T> restoreReader(Configuration config, FSDataInputStream stream, long restoredOffset, long fileLen, long splitEnd) throws IOException {
        SimpleStreamFormat.checkNotSplit(fileLen, splitEnd);
        stream.seek(restoredOffset);
        return this.createReader(config, stream);
    }

    private static void checkNotSplit(long fileLen, long splitEnd) {
        if (splitEnd != fileLen) {
            throw new IllegalArgumentException(String.format("SimpleStreamFormat is not splittable, but found split end (%d) different from file length (%d)", splitEnd, fileLen));
        }
    }
}

