/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class EdgeManager {
    private final Map<IntermediateResultPartitionID, ConsumerVertexGroup> partitionConsumers = new HashMap<IntermediateResultPartitionID, ConsumerVertexGroup>();
    private final Map<ExecutionVertexID, List<ConsumedPartitionGroup>> vertexConsumedPartitions = new HashMap<ExecutionVertexID, List<ConsumedPartitionGroup>>();
    private final Map<IntermediateResultPartitionID, List<ConsumedPartitionGroup>> consumedPartitionsById = new HashMap<IntermediateResultPartitionID, List<ConsumedPartitionGroup>>();

    public void connectPartitionWithConsumerVertexGroup(IntermediateResultPartitionID resultPartitionId, ConsumerVertexGroup consumerVertexGroup) {
        Preconditions.checkNotNull(consumerVertexGroup);
        Preconditions.checkState(this.partitionConsumers.putIfAbsent(resultPartitionId, consumerVertexGroup) == null, "Currently one partition can have at most one consumer group");
    }

    public void connectVertexWithConsumedPartitionGroup(ExecutionVertexID executionVertexId, ConsumedPartitionGroup consumedPartitionGroup) {
        Preconditions.checkNotNull(consumedPartitionGroup);
        List<ConsumedPartitionGroup> consumedPartitions = this.getConsumedPartitionGroupsForVertexInternal(executionVertexId);
        consumedPartitions.add(consumedPartitionGroup);
    }

    private List<ConsumedPartitionGroup> getConsumedPartitionGroupsForVertexInternal(ExecutionVertexID executionVertexId) {
        return this.vertexConsumedPartitions.computeIfAbsent(executionVertexId, id -> new ArrayList());
    }

    public ConsumerVertexGroup getConsumerVertexGroupForPartition(IntermediateResultPartitionID resultPartitionId) {
        return this.partitionConsumers.get(resultPartitionId);
    }

    public List<ConsumedPartitionGroup> getConsumedPartitionGroupsForVertex(ExecutionVertexID executionVertexId) {
        return Collections.unmodifiableList(this.getConsumedPartitionGroupsForVertexInternal(executionVertexId));
    }

    public void registerConsumedPartitionGroup(ConsumedPartitionGroup group) {
        for (IntermediateResultPartitionID partitionId : group) {
            this.consumedPartitionsById.computeIfAbsent(partitionId, ignore -> new ArrayList()).add(group);
        }
    }

    private List<ConsumedPartitionGroup> getConsumedPartitionGroupsByIdInternal(IntermediateResultPartitionID resultPartitionId) {
        return this.consumedPartitionsById.computeIfAbsent(resultPartitionId, id -> new ArrayList());
    }

    public List<ConsumedPartitionGroup> getConsumedPartitionGroupsById(IntermediateResultPartitionID resultPartitionId) {
        return Collections.unmodifiableList(this.getConsumedPartitionGroupsByIdInternal(resultPartitionId));
    }
}

