/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.storage;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;

class ExternalizedSnapshotLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private Path baseCheckpointPath;
    @Nullable
    private Path baseSavepointPath;

    @Nullable
    Path getBaseCheckpointPath() {
        return this.baseCheckpointPath;
    }

    @Nullable
    Path getBaseSavepointPath() {
        return this.baseSavepointPath;
    }

    private ExternalizedSnapshotLocation() {
    }

    static Builder newBuilder() {
        return new Builder();
    }

    private static Path validatePath(Path path) {
        if (path == null) {
            return null;
        }
        Optional.ofNullable(path.toUri().getScheme()).orElseThrow(() -> new IllegalArgumentException("The scheme (hdfs://, file://, etc) is null. Please specify the file system scheme explicitly in the URI."));
        Optional.ofNullable(path.getPath()).orElseThrow(() -> new IllegalArgumentException("The path to store the checkpoint data in is null. Please specify a directory path for the checkpoint data."));
        Optional.ofNullable(path.getParent()).orElseThrow(() -> new IllegalArgumentException("Cannot use the root directory for checkpoints."));
        return path;
    }

    @Nullable
    private static Path parameterOrConfigured(@Nullable Path path, ReadableConfig config, ConfigOption<String> option) {
        return Optional.ofNullable(path).orElseGet(() -> {
            try {
                return config.getOptional(option).map(Path::new).orElse(null);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalConfigurationException("Cannot parse value for " + option.key() + " . Not a valid path.", e);
            }
        });
    }

    static class Builder {
        @Nullable
        Path baseCheckpointPath;
        @Nullable
        Path baseSavepointPath;
        ReadableConfig config = new Configuration();

        Builder() {
        }

        Builder withCheckpointPath(@Nullable Path baseCheckpointPath) {
            this.baseCheckpointPath = baseCheckpointPath;
            return this;
        }

        Builder withSavepointPath(@Nullable Path baseSavepointPath) {
            this.baseSavepointPath = baseSavepointPath;
            return this;
        }

        Builder withConfiguration(ReadableConfig config) {
            this.config = config;
            return this;
        }

        ExternalizedSnapshotLocation build() {
            ExternalizedSnapshotLocation location = new ExternalizedSnapshotLocation();
            location.baseCheckpointPath = ExternalizedSnapshotLocation.validatePath(ExternalizedSnapshotLocation.parameterOrConfigured(this.baseCheckpointPath, this.config, CheckpointingOptions.CHECKPOINTS_DIRECTORY));
            location.baseSavepointPath = ExternalizedSnapshotLocation.validatePath(ExternalizedSnapshotLocation.parameterOrConfigured(this.baseSavepointPath, this.config, CheckpointingOptions.SAVEPOINT_DIRECTORY));
            return location;
        }
    }
}

