/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.TableConfigOptions;

@PublicEvolving
public class EnvironmentSettings {
    private static final EnvironmentSettings DEFAULT_STREAMING_MODE_SETTINGS = EnvironmentSettings.newInstance().inStreamingMode().build();
    private static final EnvironmentSettings DEFAULT_BATCH_MODE_SETTINGS = EnvironmentSettings.newInstance().inBatchMode().build();
    private final Configuration configuration;

    private EnvironmentSettings(Configuration configuration) {
        this.configuration = configuration;
    }

    public static EnvironmentSettings inStreamingMode() {
        return DEFAULT_STREAMING_MODE_SETTINGS;
    }

    public static EnvironmentSettings inBatchMode() {
        return DEFAULT_BATCH_MODE_SETTINGS;
    }

    public static Builder newInstance() {
        return new Builder();
    }

    @Deprecated
    public static EnvironmentSettings fromConfiguration(ReadableConfig configuration) {
        return new EnvironmentSettings((Configuration)configuration);
    }

    @Deprecated
    public Configuration toConfiguration() {
        return this.configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getBuiltInCatalogName() {
        return this.configuration.get(TableConfigOptions.TABLE_CATALOG_NAME);
    }

    public String getBuiltInDatabaseName() {
        return this.configuration.get(TableConfigOptions.TABLE_DATABASE_NAME);
    }

    public boolean isStreamingMode() {
        return this.configuration.get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
    }

    @PublicEvolving
    public static class Builder {
        private final Configuration configuration = new Configuration();

        public Builder inBatchMode() {
            this.configuration.set((ConfigOption)ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
            return this;
        }

        public Builder inStreamingMode() {
            this.configuration.set((ConfigOption)ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.STREAMING);
            return this;
        }

        public Builder withBuiltInCatalogName(String builtInCatalogName) {
            this.configuration.set((ConfigOption)TableConfigOptions.TABLE_CATALOG_NAME, builtInCatalogName);
            return this;
        }

        public Builder withBuiltInDatabaseName(String builtInDatabaseName) {
            this.configuration.set((ConfigOption)TableConfigOptions.TABLE_DATABASE_NAME, builtInDatabaseName);
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration.addAll(configuration);
            return this;
        }

        public EnvironmentSettings build() {
            return new EnvironmentSettings(this.configuration);
        }
    }
}

