/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Optional;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class CatalogFunctionImpl
implements CatalogFunction {
    private final String className;
    private final FunctionLanguage functionLanguage;

    public CatalogFunctionImpl(String className) {
        this(className, FunctionLanguage.JAVA);
    }

    public CatalogFunctionImpl(String className, FunctionLanguage functionLanguage) {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(className), "className cannot be null or empty");
        this.className = className;
        this.functionLanguage = Preconditions.checkNotNull(functionLanguage, "functionLanguage cannot be null");
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public CatalogFunction copy() {
        return new CatalogFunctionImpl(this.getClassName(), this.functionLanguage);
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.of("This is a user-defined function");
    }

    @Override
    public Optional<String> getDetailedDescription() {
        return Optional.of("This is a user-defined function");
    }

    @Override
    public boolean isGeneric() {
        if (this.functionLanguage == FunctionLanguage.PYTHON) {
            return true;
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> c = Class.forName(this.className, true, cl);
            if (UserDefinedFunction.class.isAssignableFrom(c)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Can't resolve udf class %s", this.className), e);
        }
        return false;
    }

    @Override
    public FunctionLanguage getFunctionLanguage() {
        return this.functionLanguage;
    }

    public String toString() {
        return "CatalogFunctionImpl{className='" + this.getClassName() + "', functionLanguage='" + (Object)((Object)this.getFunctionLanguage()) + "', isGeneric='" + this.isGeneric() + "'}";
    }
}

