/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sorted.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.streaming.api.operators.sorted.state.AbstractBatchExecutionKeyState;

class BatchExecutionKeyMapState<K, N, UK, UV>
extends AbstractBatchExecutionKeyState<K, N, Map<UK, UV>>
implements InternalMapState<K, N, UK, UV> {
    protected BatchExecutionKeyMapState(Map<UK, UV> defaultValue, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<Map<UK, UV>> stateTypeSerializer) {
        super(defaultValue, keySerializer, namespaceSerializer, stateTypeSerializer);
    }

    @Override
    public UV get(UK key) throws Exception {
        if (this.getCurrentNamespaceValue() == null) {
            return null;
        }
        return (UV)((Map)this.getCurrentNamespaceValue()).get(key);
    }

    @Override
    public void put(UK key, UV value) {
        this.initIfNull();
        ((Map)this.getCurrentNamespaceValue()).put(key, value);
    }

    @Override
    public void putAll(Map<UK, UV> map) {
        this.initIfNull();
        ((Map)this.getCurrentNamespaceValue()).putAll(map);
    }

    private void initIfNull() {
        if (this.getCurrentNamespaceValue() == null) {
            this.setCurrentNamespaceValue(new HashMap());
        }
    }

    @Override
    public void remove(UK key) throws Exception {
        if (this.getCurrentNamespaceValue() == null) {
            return;
        }
        ((Map)this.getCurrentNamespaceValue()).remove(key);
        if (((Map)this.getCurrentNamespaceValue()).isEmpty()) {
            this.clear();
        }
    }

    @Override
    public boolean contains(UK key) throws Exception {
        return this.getCurrentNamespaceValue() != null && ((Map)this.getCurrentNamespaceValue()).containsKey(key);
    }

    @Override
    public Iterable<Map.Entry<UK, UV>> entries() {
        return this.getCurrentNamespaceValue() == null ? Collections.emptySet() : ((Map)this.getCurrentNamespaceValue()).entrySet();
    }

    @Override
    public Iterable<UK> keys() {
        return this.getCurrentNamespaceValue() == null ? Collections.emptySet() : ((Map)this.getCurrentNamespaceValue()).keySet();
    }

    @Override
    public Iterable<UV> values() {
        return this.getCurrentNamespaceValue() == null ? Collections.emptySet() : ((Map)this.getCurrentNamespaceValue()).values();
    }

    @Override
    public Iterator<Map.Entry<UK, UV>> iterator() {
        return this.getCurrentNamespaceValue() == null ? Collections.emptyIterator() : ((Map)this.getCurrentNamespaceValue()).entrySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.getCurrentNamespaceValue() == null || ((Map)this.getCurrentNamespaceValue()).isEmpty();
    }

    static <UK, UV, K, N, SV, S extends State, IS extends S> IS create(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, StateDescriptor<S, SV> stateDesc) {
        return (IS)new BatchExecutionKeyMapState<K, N, UK, UV>((Map)stateDesc.getDefaultValue(), keySerializer, namespaceSerializer, stateDesc.getSerializer());
    }
}

