/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergingWindowSet<W extends Window> {
    private static final Logger LOG = LoggerFactory.getLogger(MergingWindowSet.class);
    private final Map<W, W> mapping;
    private final Map<W, W> initialMapping;
    private final ListState<Tuple2<W, W>> state;
    private final MergingWindowAssigner<?, W> windowAssigner;

    public MergingWindowSet(MergingWindowAssigner<?, W> windowAssigner, ListState<Tuple2<W, W>> state) throws Exception {
        this.windowAssigner = windowAssigner;
        this.mapping = new HashMap<W, W>();
        Iterable windowState = (Iterable)state.get();
        if (windowState != null) {
            for (Tuple2 window : windowState) {
                this.mapping.put(window.f0, window.f1);
            }
        }
        this.state = state;
        this.initialMapping = new HashMap<W, W>();
        this.initialMapping.putAll(this.mapping);
    }

    public void persist() throws Exception {
        if (!this.mapping.equals(this.initialMapping)) {
            this.state.clear();
            for (Map.Entry<W, W> window : this.mapping.entrySet()) {
                this.state.add(new Tuple2<W, W>(window.getKey(), window.getValue()));
            }
        }
    }

    public W getStateWindow(W window) {
        return (W)((Window)this.mapping.get(window));
    }

    public void retireWindow(W window) {
        Window removed = (Window)this.mapping.remove(window);
        if (removed == null) {
            throw new IllegalStateException("Window " + window + " is not in in-flight window set.");
        }
    }

    public W addWindow(W newWindow, MergeFunction<W> mergeFunction) throws Exception {
        ArrayList<W> windows = new ArrayList<W>();
        windows.addAll(this.mapping.keySet());
        windows.add(newWindow);
        final HashMap mergeResults = new HashMap();
        this.windowAssigner.mergeWindows(windows, new MergingWindowAssigner.MergeCallback<W>(){

            @Override
            public void merge(Collection<W> toBeMerged, W mergeResult) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Merging {} into {}", toBeMerged, mergeResult);
                }
                mergeResults.put(mergeResult, toBeMerged);
            }
        });
        Object resultWindow = newWindow;
        boolean mergedNewWindow = false;
        for (Map.Entry c : mergeResults.entrySet()) {
            Window mergeResult = (Window)c.getKey();
            Collection mergedWindows = (Collection)c.getValue();
            if (mergedWindows.remove(newWindow)) {
                mergedNewWindow = true;
                resultWindow = mergeResult;
            }
            Window mergedStateWindow = (Window)this.mapping.get(mergedWindows.iterator().next());
            ArrayList<Window> mergedStateWindows = new ArrayList<Window>();
            for (Window mergedWindow : mergedWindows) {
                Window res = (Window)this.mapping.remove(mergedWindow);
                if (res == null) continue;
                mergedStateWindows.add(res);
            }
            this.mapping.put(mergeResult, mergedStateWindow);
            mergedStateWindows.remove(mergedStateWindow);
            if (mergedWindows.contains(mergeResult) && mergedWindows.size() == 1) continue;
            mergeFunction.merge(mergeResult, mergedWindows, (Window)this.mapping.get(mergeResult), (Collection<Window>)mergedStateWindows);
        }
        if (mergeResults.isEmpty() || resultWindow.equals(newWindow) && !mergedNewWindow) {
            this.mapping.put(resultWindow, resultWindow);
        }
        return resultWindow;
    }

    public String toString() {
        return "MergingWindowSet{windows=" + this.mapping + '}';
    }

    public static interface MergeFunction<W> {
        public void merge(W var1, Collection<W> var2, W var3, Collection<W> var4) throws Exception;
    }
}

