/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.collector.TableFunctionCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.util.Collector;

public class LookupJoinRunner
extends ProcessFunction<RowData, RowData> {
    private static final long serialVersionUID = -4521543015709964733L;
    private final GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher;
    private final GeneratedCollector<TableFunctionCollector<RowData>> generatedCollector;
    private final boolean isLeftOuterJoin;
    private final int tableFieldsCount;
    private transient FlatMapFunction<RowData, RowData> fetcher;
    protected transient TableFunctionCollector<RowData> collector;
    private transient GenericRowData nullRow;
    private transient JoinedRowData outRow;

    public LookupJoinRunner(GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher, GeneratedCollector<TableFunctionCollector<RowData>> generatedCollector, boolean isLeftOuterJoin, int tableFieldsCount) {
        this.generatedFetcher = generatedFetcher;
        this.generatedCollector = generatedCollector;
        this.isLeftOuterJoin = isLeftOuterJoin;
        this.tableFieldsCount = tableFieldsCount;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.fetcher = (FlatMapFunction)this.generatedFetcher.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.collector = (TableFunctionCollector)this.generatedCollector.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, this.getRuntimeContext());
        FunctionUtils.setFunctionRuntimeContext(this.collector, this.getRuntimeContext());
        FunctionUtils.openFunction(this.fetcher, parameters);
        FunctionUtils.openFunction(this.collector, parameters);
        this.nullRow = new GenericRowData(this.tableFieldsCount);
        this.outRow = new JoinedRowData();
    }

    @Override
    public void processElement(RowData in, ProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        this.collector.setCollector(out);
        this.collector.setInput(in);
        this.collector.reset();
        this.fetcher.flatMap(in, this.getFetcherCollector());
        if (this.isLeftOuterJoin && !this.collector.isCollected()) {
            this.outRow.replace(in, this.nullRow);
            this.outRow.setRowKind(in.getRowKind());
            out.collect(this.outRow);
        }
    }

    public Collector<RowData> getFetcherCollector() {
        return this.collector;
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.fetcher != null) {
            FunctionUtils.closeFunction(this.fetcher);
        }
        if (this.collector != null) {
            FunctionUtils.closeFunction(this.collector);
        }
    }
}

