/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.operators.over.frame.UnboundedPrecedingOverFrame;

public class RangeUnboundedPrecedingOverFrame
extends UnboundedPrecedingOverFrame {
    private GeneratedRecordComparator boundComparator;
    private RecordComparator rbound;

    public RangeUnboundedPrecedingOverFrame(GeneratedAggsHandleFunction aggsHandleFunction, GeneratedRecordComparator boundComparator) {
        super(aggsHandleFunction);
        this.boundComparator = boundComparator;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        this.rbound = (RecordComparator)this.boundComparator.newInstance(ctx.getRuntimeContext().getUserCodeClassLoader());
        this.boundComparator = null;
    }

    @Override
    public RowData process(int index, RowData current) throws Exception {
        boolean bufferUpdated;
        boolean bl = bufferUpdated = index == 0;
        while (this.nextRow != null && this.rbound.compare(this.nextRow, current) <= 0) {
            this.processor.accumulate(this.nextRow);
            this.nextRow = OverWindowFrame.getNextOrNull(this.inputIterator);
            bufferUpdated = true;
        }
        if (bufferUpdated) {
            this.accValue = this.processor.getValue();
        }
        return this.accValue;
    }
}

