/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.AbstractHaServices;
import org.apache.flink.runtime.highavailability.FileSystemJobResultStore;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator5.org.apache.curator.utils.ZKPaths;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.util.Preconditions;

public abstract class AbstractZooKeeperHaServices
extends AbstractHaServices {
    private final CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper;

    public AbstractZooKeeperHaServices(CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper, Executor executor, Configuration configuration, BlobStoreService blobStoreService) throws IOException {
        super(configuration, executor, blobStoreService, FileSystemJobResultStore.fromConfiguration(configuration));
        this.curatorFrameworkWrapper = Preconditions.checkNotNull(curatorFrameworkWrapper);
    }

    protected final CuratorFramework getCuratorFramework() {
        return this.curatorFrameworkWrapper.asCuratorFramework();
    }

    @Override
    public CheckpointRecoveryFactory createCheckpointRecoveryFactory() throws Exception {
        return new ZooKeeperCheckpointRecoveryFactory(ZooKeeperUtils.useNamespaceAndEnsurePath(this.curatorFrameworkWrapper.asCuratorFramework(), ZooKeeperUtils.getJobsPath()), this.configuration, this.ioExecutor);
    }

    @Override
    public JobGraphStore createJobGraphStore() throws Exception {
        return ZooKeeperUtils.createJobGraphs(this.curatorFrameworkWrapper.asCuratorFramework(), this.configuration);
    }

    @Override
    protected void internalClose() throws Exception {
        this.curatorFrameworkWrapper.close();
    }

    @Override
    protected void internalCleanup() throws Exception {
        this.cleanupZooKeeperPaths();
    }

    @Override
    protected void internalCleanupJobData(JobID jobID) throws Exception {
        this.deleteZNode(ZooKeeperUtils.getLeaderPathForJob(jobID));
    }

    private void cleanupZooKeeperPaths() throws Exception {
        this.deleteOwnedZNode();
        this.tryDeleteEmptyParentZNodes();
    }

    private void deleteOwnedZNode() throws Exception {
        this.deleteZNode("/");
    }

    protected void deleteZNode(String path) throws Exception {
        ZooKeeperUtils.deleteZNode(this.curatorFrameworkWrapper.asCuratorFramework(), path);
    }

    private void tryDeleteEmptyParentZNodes() throws Exception {
        String remainingPath = AbstractZooKeeperHaServices.getParentPath(AbstractZooKeeperHaServices.getNormalizedPath(this.curatorFrameworkWrapper.asCuratorFramework().getNamespace()));
        CuratorFramework nonNamespaceClient = this.curatorFrameworkWrapper.asCuratorFramework().usingNamespace(null);
        while (!AbstractZooKeeperHaServices.isRootPath(remainingPath)) {
            try {
                nonNamespaceClient.delete().forPath(remainingPath);
            }
            catch (KeeperException.NotEmptyException ignored) {
                break;
            }
            remainingPath = AbstractZooKeeperHaServices.getParentPath(remainingPath);
        }
    }

    private static boolean isRootPath(String remainingPath) {
        return "/".equals(remainingPath);
    }

    private static String getNormalizedPath(String path) {
        return ZKPaths.makePath((String)path, (String)"");
    }

    private static String getParentPath(String path) {
        return ZKPaths.getPathAndNode((String)path).getPath();
    }
}

