/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import java.util.Arrays;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.store.codegen.CodeGenUtils;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.table.sink.SinkRecord;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;

public class SinkRecordConverter {
    private final int numBucket;
    private final Projection<RowData, BinaryRowData> allProjection;
    private final Projection<RowData, BinaryRowData> partProjection;
    private final Projection<RowData, BinaryRowData> bucketProjection;
    private final Projection<RowData, BinaryRowData> pkProjection;
    @Nullable
    private final Projection<RowData, BinaryRowData> logPkProjection;

    public SinkRecordConverter(int numBucket, TableSchema tableSchema) {
        this(numBucket, tableSchema.logicalRowType(), tableSchema.projection(tableSchema.partitionKeys()), tableSchema.projection(tableSchema.originalBucketKeys()), tableSchema.projection(tableSchema.trimmedPrimaryKeys()), tableSchema.projection(tableSchema.primaryKeys()));
    }

    private SinkRecordConverter(int numBucket, RowType inputType, int[] partitions, int[] bucketKeys, int[] primaryKeys, int[] logPrimaryKeys) {
        this.numBucket = numBucket;
        this.allProjection = CodeGenUtils.newProjection(inputType, IntStream.range(0, inputType.getFieldCount()).toArray());
        this.partProjection = CodeGenUtils.newProjection(inputType, partitions);
        this.bucketProjection = CodeGenUtils.newProjection(inputType, bucketKeys);
        this.pkProjection = CodeGenUtils.newProjection(inputType, primaryKeys);
        this.logPkProjection = Arrays.equals(primaryKeys, logPrimaryKeys) ? null : CodeGenUtils.newProjection(inputType, logPrimaryKeys);
    }

    public SinkRecord convert(RowData row) {
        BinaryRowData partition = this.partProjection.apply(row);
        BinaryRowData primaryKey = this.primaryKey(row);
        int bucket = this.bucket(row, this.bucketKey(row, primaryKey));
        return new SinkRecord(partition, bucket, primaryKey, row);
    }

    public SinkRecord convertToLogSinkRecord(SinkRecord record) {
        if (this.logPkProjection == null) {
            return record;
        }
        BinaryRowData logPrimaryKey = this.logPrimaryKey(record.row());
        return new SinkRecord(record.partition(), record.bucket(), logPrimaryKey, record.row());
    }

    public int bucket(RowData row) {
        return this.bucket(row, this.bucketKey(row));
    }

    private BinaryRowData primaryKey(RowData row) {
        return this.pkProjection.apply(row);
    }

    private BinaryRowData bucketKey(RowData row) {
        BinaryRowData bucketKey = this.bucketProjection.apply(row);
        return bucketKey.getArity() == 0 ? this.pkProjection.apply(row) : bucketKey;
    }

    private BinaryRowData bucketKey(RowData row, BinaryRowData primaryKey) {
        BinaryRowData bucketKey = this.bucketProjection.apply(row);
        return bucketKey.getArity() == 0 ? primaryKey : bucketKey;
    }

    private BinaryRowData logPrimaryKey(RowData row) {
        assert (this.logPkProjection != null);
        return this.logPkProjection.apply(row);
    }

    private int bucket(RowData row, BinaryRowData bucketKey) {
        int hash = bucketKey.getArity() == 0 ? this.hashRow(row) : SinkRecordConverter.hashcode(bucketKey);
        return SinkRecordConverter.bucket(hash, this.numBucket);
    }

    private int hashRow(RowData row) {
        if (row instanceof BinaryRowData) {
            RowKind rowKind = row.getRowKind();
            row.setRowKind(RowKind.INSERT);
            int hash = SinkRecordConverter.hashcode((BinaryRowData)row);
            row.setRowKind(rowKind);
            return hash;
        }
        return SinkRecordConverter.hashcode(this.allProjection.apply(row));
    }

    public static int hashcode(BinaryRowData rowData) {
        assert (rowData.getRowKind() == RowKind.INSERT);
        return rowData.hashCode();
    }

    public static int bucket(int hashcode, int numBucket) {
        return Math.abs(hashcode % numBucket);
    }
}

