/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source;

import java.util.List;
import java.util.function.Function;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.table.source.SplitGenerator;
import org.apache.flink.table.store.utils.OrderedPacking;

public class AppendOnlySplitGenerator
implements SplitGenerator {
    private final long targetSplitSize;
    private final long openFileCost;

    public AppendOnlySplitGenerator(long targetSplitSize, long openFileCost) {
        this.targetSplitSize = targetSplitSize;
        this.openFileCost = openFileCost;
    }

    @Override
    public List<List<DataFileMeta>> split(List<DataFileMeta> files) {
        Function<DataFileMeta, Long> weightFunc = file -> Math.max(file.fileSize(), this.openFileCost);
        return OrderedPacking.pack(files, weightFunc, this.targetSplitSize);
    }
}

