/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.io;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Collector;

public class WorksetUpdateOutputCollector<T>
implements Collector<T> {
    private final TypeSerializer<T> serializer;
    private final DataOutputView outputView;
    private long elementsCollected;
    private Collector<T> delegate;

    public WorksetUpdateOutputCollector(DataOutputView outputView, TypeSerializer<T> serializer) {
        this(outputView, serializer, null);
    }

    public WorksetUpdateOutputCollector(DataOutputView outputView, TypeSerializer<T> serializer, Collector<T> delegate) {
        this.outputView = outputView;
        this.serializer = serializer;
        this.delegate = delegate;
        this.elementsCollected = 0L;
    }

    @Override
    public void collect(T record) {
        try {
            this.serializer.serialize(record, this.outputView);
            if (this.delegate != null) {
                this.delegate.collect(record);
            }
            ++this.elementsCollected;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize the record", e);
        }
    }

    public long getElementsCollectedAndReset() {
        long elementsCollectedToReturn = this.elementsCollected;
        this.elementsCollected = 0L;
        return elementsCollectedToReturn;
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

