/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.util.Preconditions;

public enum LeastUtilizationSlotMatchingStrategy implements SlotMatchingStrategy
{
    INSTANCE;


    @Override
    public <T extends TaskManagerSlotInformation> Optional<T> findMatchingSlot(ResourceProfile requestedProfile, Collection<T> freeSlots, Function<InstanceID, Integer> numberRegisteredSlotsLookup) {
        Map<InstanceID, Integer> numSlotsPerTaskExecutor = freeSlots.stream().collect(Collectors.groupingBy(TaskManagerSlotInformation::getInstanceId, Collectors.reducing(0, i -> 1, Integer::sum)));
        return freeSlots.stream().filter(taskManagerSlot -> taskManagerSlot.isMatchingRequirement(requestedProfile)).min(Comparator.comparingDouble(taskManagerSlot -> LeastUtilizationSlotMatchingStrategy.calculateUtilization(taskManagerSlot.getInstanceId(), numberRegisteredSlotsLookup, numSlotsPerTaskExecutor)));
    }

    private static double calculateUtilization(InstanceID instanceId, Function<? super InstanceID, Integer> numberRegisteredSlotsLookup, Map<InstanceID, Integer> numSlotsPerTaskExecutor) {
        int numberRegisteredSlots = numberRegisteredSlotsLookup.apply(instanceId);
        Preconditions.checkArgument(numberRegisteredSlots > 0, "The TaskExecutor %s has no slots registered.", instanceId);
        int numberFreeSlots = numSlotsPerTaskExecutor.getOrDefault(instanceId, 0);
        Preconditions.checkArgument(numberRegisteredSlots >= numberFreeSlots, "The TaskExecutor %s has fewer registered slots than free slots.", instanceId);
        return (double)(numberRegisteredSlots - numberFreeSlots) / (double)numberRegisteredSlots;
    }
}

