/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;

public abstract class TableStreamOperator<OUT>
extends AbstractStreamOperator<OUT> {
    protected long currentWatermark = Long.MIN_VALUE;
    protected transient ContextImpl ctx;

    public TableStreamOperator() {
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.ctx = new ContextImpl(this.getProcessingTimeService());
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    public long computeMemorySize() {
        Environment environment = this.getContainingTask().getEnvironment();
        return environment.getMemoryManager().computeMemorySize(this.getOperatorConfig().getManagedMemoryFractionOperatorUseCaseOfSlot(ManagedMemoryUseCase.OPERATOR, environment.getTaskManagerInfo().getConfiguration(), environment.getUserCodeClassLoader().asClassLoader()));
    }

    protected class ContextImpl
    implements TimerService {
        protected final ProcessingTimeService timerService;
        public StreamRecord<?> element;

        ContextImpl(ProcessingTimeService timerService) {
            this.timerService = Preconditions.checkNotNull(timerService);
        }

        public Long timestamp() {
            Preconditions.checkState(this.element != null);
            if (this.element.hasTimestamp()) {
                return this.element.getTimestamp();
            }
            return null;
        }

        @Override
        public long currentProcessingTime() {
            return this.timerService.getCurrentProcessingTime();
        }

        @Override
        public long currentWatermark() {
            return TableStreamOperator.this.currentWatermark;
        }

        @Override
        public void registerProcessingTimeTimer(long time) {
            throw new UnsupportedOperationException("Setting timers is only supported on a keyed streams.");
        }

        @Override
        public void registerEventTimeTimer(long time) {
            throw new UnsupportedOperationException("Setting timers is only supported on a keyed streams.");
        }

        @Override
        public void deleteProcessingTimeTimer(long time) {
            throw new UnsupportedOperationException("Delete timers is only supported on a keyed streams.");
        }

        @Override
        public void deleteEventTimeTimer(long time) {
            throw new UnsupportedOperationException("Delete timers is only supported on a keyed streams.");
        }

        public TimerService timerService() {
            return this;
        }
    }
}

