/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.lookup;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.lookup.PrimaryKeyLookupTable;
import org.apache.flink.table.store.connector.lookup.RocksDBStateFactory;
import org.apache.flink.table.store.connector.lookup.SecondaryIndexLookupTable;
import org.apache.flink.table.types.logical.RowType;

public interface LookupTable {
    public List<RowData> get(RowData var1) throws IOException;

    public void refresh(Iterator<RowData> var1) throws IOException;

    public static LookupTable create(RocksDBStateFactory stateFactory, RowType rowType, List<String> primaryKey, List<String> joinKey, Predicate<RowData> recordFilter, long lruCacheSize) throws IOException {
        if (new HashSet<String>(primaryKey).equals(new HashSet<String>(joinKey))) {
            return new PrimaryKeyLookupTable(stateFactory, rowType, joinKey, recordFilter, lruCacheSize);
        }
        return new SecondaryIndexLookupTable(stateFactory, rowType, primaryKey, joinKey, recordFilter, lruCacheSize);
    }
}

