/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.quota;

import java.util.Objects;
import java.util.Optional;

public class ClientQuotaFilterComponent {
    private final String entityType;
    private final Optional<String> match;

    private ClientQuotaFilterComponent(String entityType, Optional<String> match) {
        this.entityType = Objects.requireNonNull(entityType);
        this.match = match;
    }

    public static ClientQuotaFilterComponent ofEntity(String entityType, String entityName) {
        return new ClientQuotaFilterComponent(entityType, Optional.of(Objects.requireNonNull(entityName)));
    }

    public static ClientQuotaFilterComponent ofDefaultEntity(String entityType) {
        return new ClientQuotaFilterComponent(entityType, Optional.empty());
    }

    public static ClientQuotaFilterComponent ofEntityType(String entityType) {
        return new ClientQuotaFilterComponent(entityType, null);
    }

    public String entityType() {
        return this.entityType;
    }

    public Optional<String> match() {
        return this.match;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientQuotaFilterComponent that = (ClientQuotaFilterComponent)o;
        return Objects.equals(that.entityType, this.entityType) && Objects.equals(that.match, this.match);
    }

    public int hashCode() {
        return Objects.hash(this.entityType, this.match);
    }

    public String toString() {
        return "ClientQuotaFilterComponent(entityType=" + this.entityType + ", match=" + this.match + ")";
    }
}

