/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.utils.AppInfoParser;

public class ApiVersionsRequest
extends AbstractRequest {
    private static final Pattern SOFTWARE_NAME_VERSION_PATTERN = Pattern.compile("[a-zA-Z0-9](?:[a-zA-Z0-9\\-.]*[a-zA-Z0-9])?");
    private final Short unsupportedRequestVersion;
    private final ApiVersionsRequestData data;

    public ApiVersionsRequest(ApiVersionsRequestData data, short version) {
        this(data, version, null);
    }

    public ApiVersionsRequest(ApiVersionsRequestData data, short version, Short unsupportedRequestVersion) {
        super(ApiKeys.API_VERSIONS, version);
        this.data = data;
        this.unsupportedRequestVersion = unsupportedRequestVersion;
    }

    public boolean hasUnsupportedRequestVersion() {
        return this.unsupportedRequestVersion != null;
    }

    public boolean isValid() {
        if (this.version() >= 3) {
            return SOFTWARE_NAME_VERSION_PATTERN.matcher(this.data.clientSoftwareName()).matches() && SOFTWARE_NAME_VERSION_PATTERN.matcher(this.data.clientSoftwareVersion()).matches();
        }
        return true;
    }

    @Override
    public ApiVersionsRequestData data() {
        return this.data;
    }

    @Override
    public ApiVersionsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiVersionsResponseData data = new ApiVersionsResponseData().setErrorCode(Errors.forException(e).code());
        if (this.version() >= 1) {
            data.setThrottleTimeMs(throttleTimeMs);
        }
        if (Errors.forException(e) == Errors.UNSUPPORTED_VERSION) {
            ApiVersionsResponseData.ApiVersionCollection apiKeys = new ApiVersionsResponseData.ApiVersionCollection();
            apiKeys.add(ApiVersionsResponse.toApiVersion(ApiKeys.API_VERSIONS));
            data.setApiKeys(apiKeys);
        }
        return new ApiVersionsResponse(data);
    }

    public static ApiVersionsRequest parse(ByteBuffer buffer, short version) {
        return new ApiVersionsRequest(new ApiVersionsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ApiVersionsRequest> {
        private static final String DEFAULT_CLIENT_SOFTWARE_NAME = "apache-kafka-java";
        private static final ApiVersionsRequestData DATA = new ApiVersionsRequestData().setClientSoftwareName("apache-kafka-java").setClientSoftwareVersion(AppInfoParser.getVersion());

        public Builder() {
            super(ApiKeys.API_VERSIONS);
        }

        public Builder(short version) {
            super(ApiKeys.API_VERSIONS, version);
        }

        @Override
        public ApiVersionsRequest build(short version) {
            return new ApiVersionsRequest(DATA, version);
        }

        public String toString() {
            return DATA.toString();
        }
    }
}

