/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.parquet.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.AesCipher;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.AesMode;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.TagVerificationException;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.BlockCipher;

public class AesGcmDecryptor
extends AesCipher
implements BlockCipher.Decryptor {
    AesGcmDecryptor(byte[] keyBytes) {
        super(AesMode.GCM, keyBytes);
        try {
            this.cipher = Cipher.getInstance(AesMode.GCM.getCipherName());
        }
        catch (GeneralSecurityException e) {
            throw new ParquetCryptoRuntimeException("Failed to create GCM cipher", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] lengthAndCiphertext, byte[] AAD) {
        int cipherTextOffset = 4;
        int cipherTextLength = lengthAndCiphertext.length - 4;
        return this.decrypt(lengthAndCiphertext, cipherTextOffset, cipherTextLength, AAD);
    }

    public byte[] decrypt(byte[] ciphertext, int cipherTextOffset, int cipherTextLength, byte[] AAD) {
        int plainTextLength = cipherTextLength - 16 - 12;
        if (plainTextLength < 1) {
            throw new ParquetCryptoRuntimeException("Wrong input length " + plainTextLength);
        }
        System.arraycopy(ciphertext, cipherTextOffset, this.localNonce, 0, 12);
        byte[] plainText = new byte[plainTextLength];
        int inputLength = cipherTextLength - 12;
        int inputOffset = cipherTextOffset + 12;
        int outputOffset = 0;
        try {
            GCMParameterSpec spec = new GCMParameterSpec(128, this.localNonce);
            this.cipher.init(2, (Key)this.aesKey, spec);
            if (null != AAD) {
                this.cipher.updateAAD(AAD);
            }
            this.cipher.doFinal(ciphertext, inputOffset, inputLength, plainText, outputOffset);
        }
        catch (AEADBadTagException e) {
            throw new TagVerificationException("GCM tag check failed", e);
        }
        catch (GeneralSecurityException e) {
            throw new ParquetCryptoRuntimeException("Failed to decrypt", e);
        }
        return plainText;
    }

    @Override
    public byte[] decrypt(InputStream from, byte[] AAD) throws IOException {
        int n;
        int gotBytes;
        int n2;
        byte[] lengthBuffer = new byte[4];
        for (gotBytes = 0; gotBytes < 4; gotBytes += n2) {
            n2 = from.read(lengthBuffer, gotBytes, 4 - gotBytes);
            if (n2 > 0) continue;
            throw new IOException("Tried to read int (4 bytes), but only got " + gotBytes + " bytes.");
        }
        int ciphertextLength = (lengthBuffer[3] & 0xFF) << 24 | (lengthBuffer[2] & 0xFF) << 16 | (lengthBuffer[1] & 0xFF) << 8 | lengthBuffer[0] & 0xFF;
        if (ciphertextLength < 1) {
            throw new IOException("Wrong length of encrypted metadata: " + ciphertextLength);
        }
        byte[] ciphertextBuffer = new byte[ciphertextLength];
        for (gotBytes = 0; gotBytes < ciphertextLength; gotBytes += n) {
            n = from.read(ciphertextBuffer, gotBytes, ciphertextLength - gotBytes);
            if (n > 0) continue;
            throw new IOException("Tried to read " + ciphertextLength + " bytes, but only got " + gotBytes + " bytes.");
        }
        return this.decrypt(ciphertextBuffer, 0, ciphertextLength, AAD);
    }
}

