/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.compact;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.mergetree.LevelSortedRun;

public interface CompactUnit {
    public int outputLevel();

    public List<DataFileMeta> files();

    public static CompactUnit fromLevelRuns(int outputLevel, List<LevelSortedRun> runs) {
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>();
        for (LevelSortedRun run : runs) {
            files.addAll(run.run().files());
        }
        return CompactUnit.fromFiles(outputLevel, files);
    }

    public static CompactUnit fromFiles(final int outputLevel, final List<DataFileMeta> files) {
        return new CompactUnit(){

            @Override
            public int outputLevel() {
                return outputLevel;
            }

            @Override
            public List<DataFileMeta> files() {
                return files;
            }
        };
    }
}

