/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.KeyValueSerializer;
import org.apache.flink.table.store.file.io.AbstractFileRecordIterator;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.types.logical.RowType;

public class KeyValueDataFileRecordReader
implements RecordReader<KeyValue> {
    private final BulkFormat.Reader<RowData> reader;
    private final KeyValueSerializer serializer;
    private final int level;
    @Nullable
    private final int[] indexMapping;

    public KeyValueDataFileRecordReader(BulkFormat<RowData, FileSourceSplit> readerFactory, Path path, RowType keyType, RowType valueType, int level, @Nullable int[] indexMapping) throws IOException {
        this.reader = FileUtils.createFormatReader(readerFactory, path);
        this.serializer = new KeyValueSerializer(keyType, valueType);
        this.level = level;
        this.indexMapping = indexMapping;
    }

    @Override
    @Nullable
    public RecordReader.RecordIterator<KeyValue> readBatch() throws IOException {
        BulkFormat.RecordIterator iterator = this.reader.readBatch();
        return iterator == null ? null : new KeyValueDataFileRecordIterator(iterator, this.indexMapping);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private class KeyValueDataFileRecordIterator
    extends AbstractFileRecordIterator<KeyValue> {
        private final BulkFormat.RecordIterator<RowData> iterator;

        private KeyValueDataFileRecordIterator(@Nullable BulkFormat.RecordIterator<RowData> iterator, int[] indexMapping) {
            super(indexMapping);
            this.iterator = iterator;
        }

        @Override
        public KeyValue next() throws IOException {
            RecordAndPosition result = this.iterator.next();
            if (result == null) {
                return null;
            }
            return KeyValueDataFileRecordReader.this.serializer.fromRow(this.mappingRowData((RowData)result.getRecord())).setLevel(KeyValueDataFileRecordReader.this.level);
        }

        @Override
        public void releaseBatch() {
            this.iterator.releaseBatch();
        }
    }
}

