/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.manifest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.store.file.manifest.ManifestCommittable;
import org.apache.flink.table.store.table.sink.FileCommittable;
import org.apache.flink.table.store.table.sink.FileCommittableSerializer;

public class ManifestCommittableSerializer
implements SimpleVersionedSerializer<ManifestCommittable> {
    private static final int CURRENT_VERSION = 2;
    private final FileCommittableSerializer fileCommittableSerializer = new FileCommittableSerializer();

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(ManifestCommittable obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        view.writeLong(obj.identifier());
        this.serializeOffsets(view, obj.logOffsets());
        view.writeInt(this.fileCommittableSerializer.getVersion());
        this.fileCommittableSerializer.serializeList(obj.fileCommittables(), (DataOutputView)view);
        return out.toByteArray();
    }

    private void serializeOffsets(DataOutputViewStreamWrapper view, Map<Integer, Long> offsets) throws IOException {
        view.writeInt(offsets.size());
        for (Map.Entry<Integer, Long> entry : offsets.entrySet()) {
            view.writeInt(entry.getKey().intValue());
            view.writeLong(entry.getValue().longValue());
        }
    }

    public ManifestCommittable deserialize(int version, byte[] serialized) throws IOException {
        if (version != 2) {
            throw new UnsupportedOperationException("Expecting ManifestCommittable version to be 2, but found " + version + ".\nManifestCommittable is not a compatible data structure. Please restart the job afresh (do not recover from savepoint).");
        }
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        long identifier = view.readLong();
        Map<Integer, Long> offsets = this.deserializeOffsets(view);
        int fileCommittableSerializerVersion = view.readInt();
        List<FileCommittable> fileCommittables = this.fileCommittableSerializer.deserializeList(fileCommittableSerializerVersion, (DataInputView)view);
        return new ManifestCommittable(identifier, offsets, fileCommittables);
    }

    private Map<Integer, Long> deserializeOffsets(DataInputDeserializer view) throws IOException {
        int size = view.readInt();
        HashMap<Integer, Long> offsets = new HashMap<Integer, Long>(size);
        for (int i = 0; i < size; ++i) {
            offsets.put(view.readInt(), view.readLong());
        }
        return offsets;
    }
}

