/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy;

import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyShortObjectInspector;

public class LazyShort
extends LazyPrimitive<LazyShortObjectInspector, ShortWritable> {
    public LazyShort(LazyShortObjectInspector oi) {
        super(oi);
        this.data = new ShortWritable();
    }

    public LazyShort(LazyShort copy) {
        super(copy);
        this.data = new ShortWritable(((ShortWritable)copy.data).get());
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        if (!LazyUtils.isNumberMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        try {
            ((ShortWritable)this.data).set(LazyShort.parseShort(bytes.getData(), start, length));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "SMALLINT");
        }
    }

    public static short parseShort(byte[] bytes, int start, int length) {
        return LazyShort.parseShort(bytes, start, length, 10);
    }

    public static short parseShort(byte[] bytes, int start, int length, int radix) {
        int intValue = LazyInteger.parseInt(bytes, start, length, radix);
        short result = (short)intValue;
        if (result == intValue) {
            return result;
        }
        throw new NumberFormatException();
    }
}

