/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Decimal;

public class DecimalUtils {
    public static Decimal getDecimal(int number, int scale) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.asIntBuffer().put(number);
        return new Decimal((short)scale, bb);
    }

    public static Decimal getDecimal(ByteBuffer unscaled, short scale) {
        return new Decimal(scale, unscaled);
    }

    public static Decimal createThriftDecimal(String s) {
        BigDecimal d = new BigDecimal(s);
        return new Decimal((short)d.scale(), ByteBuffer.wrap(d.unscaledValue().toByteArray()));
    }

    public static String createJdoDecimalString(Decimal d) {
        return new BigDecimal(new BigInteger(d.getUnscaled()), d.getScale()).toString();
    }
}

