/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferHeader;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.CompositeByteBuf;
import org.apache.flink.util.Preconditions;

public class CompositeBuffer
implements Buffer {
    private final Buffer.DataType dataType;
    private final int length;
    private final boolean isCompressed;
    private final List<Buffer> partialBuffers = new ArrayList<Buffer>();
    private int currentLength;
    private ByteBufAllocator allocator;

    public CompositeBuffer(Buffer.DataType dataType, int length, boolean isCompressed) {
        this.dataType = Preconditions.checkNotNull(dataType);
        this.length = length;
        this.isCompressed = isCompressed;
    }

    public CompositeBuffer(BufferHeader header) {
        this(header.getDataType(), header.getLength(), header.isCompressed());
    }

    @Override
    public boolean isBuffer() {
        return this.dataType.isBuffer();
    }

    @Override
    public void recycleBuffer() {
        for (Buffer partialBuffer : this.partialBuffers) {
            partialBuffer.recycleBuffer();
        }
    }

    @Override
    public Buffer retainBuffer() {
        for (Buffer partialBuffer : this.partialBuffers) {
            partialBuffer.retainBuffer();
        }
        return this;
    }

    @Override
    public int getSize() {
        return this.currentLength;
    }

    @Override
    public int readableBytes() {
        return this.currentLength;
    }

    @Override
    public void setAllocator(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public ByteBuf asByteBuf() {
        CompositeByteBuf compositeByteBuf = Preconditions.checkNotNull(this.allocator).compositeDirectBuffer();
        for (Buffer buffer : this.partialBuffers) {
            compositeByteBuf.addComponent(buffer.asByteBuf());
        }
        compositeByteBuf.writerIndex(this.currentLength);
        return compositeByteBuf;
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public Buffer.DataType getDataType() {
        return this.dataType;
    }

    public int numPartialBuffers() {
        return this.partialBuffers.size();
    }

    public Buffer getFullBufferData(MemorySegment segment) {
        Preconditions.checkState(!this.partialBuffers.isEmpty());
        Preconditions.checkState(this.currentLength <= segment.size());
        if (this.partialBuffers.size() == 1) {
            return this.partialBuffers.get(0);
        }
        int offset = 0;
        for (Buffer buffer : this.partialBuffers) {
            segment.put(offset, buffer.getNioBufferReadable(), buffer.readableBytes());
            offset += buffer.readableBytes();
        }
        this.recycleBuffer();
        return new NetworkBuffer(segment, BufferRecycler.DummyBufferRecycler.INSTANCE, this.dataType, this.isCompressed, this.currentLength);
    }

    public void addPartialBuffer(Buffer buffer) {
        buffer.setDataType(this.dataType);
        buffer.setCompressed(this.isCompressed);
        this.partialBuffers.add(buffer);
        this.currentLength += buffer.readableBytes();
        Preconditions.checkState(this.currentLength <= this.length);
    }

    public int missingLength() {
        return this.length - this.currentLength;
    }

    @Override
    public MemorySegment getMemorySegment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMemorySegmentOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BufferRecycler getRecycler() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRecycled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Buffer readOnlySlice() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Buffer readOnlySlice(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxCapacity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getReaderIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReaderIndex(int readerIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSize(int writerIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getNioBufferReadable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getNioBuffer(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCompressed(boolean isCompressed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataType(Buffer.DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int refCnt() {
        throw new UnsupportedOperationException();
    }
}

