/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.modules;

import org.apache.flink.runtime.hadoop.HadoopDependency;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.modules.HadoopModule;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.flink.runtime.security.modules.SecurityModuleFactory;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopModuleFactory
implements SecurityModuleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopModuleFactory.class);

    @Override
    public SecurityModule createModule(SecurityConfiguration securityConfig) {
        if (!HadoopDependency.isHadoopCommonOnClasspath(HadoopModule.class.getClassLoader())) {
            LOG.info("Cannot create Hadoop Security Module because Hadoop cannot be found in the Classpath.");
            return null;
        }
        try {
            Configuration hadoopConfiguration = HadoopUtils.getHadoopConfiguration(securityConfig.getFlinkConfig());
            return new HadoopModule(securityConfig, hadoopConfiguration);
        }
        catch (LinkageError e) {
            LOG.error("Cannot create Hadoop Security Module.", (Throwable)e);
            return null;
        }
    }
}

