/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source;

import java.io.IOException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.table.source.ResetRowKindRecordIterator;
import org.apache.flink.types.RowKind;

public class ValueCountRowDataRecordIterator
extends ResetRowKindRecordIterator {
    private RowData rowData = null;
    private long count = 0L;

    public ValueCountRowDataRecordIterator(RecordReader.RecordIterator<KeyValue> kvIterator) {
        super(kvIterator);
    }

    @Override
    public RowData next() throws IOException {
        while (true) {
            if (this.count > 0L) {
                --this.count;
                return this.rowData;
            }
            KeyValue kv = this.nextKeyValue();
            if (kv == null) {
                return null;
            }
            this.rowData = kv.key();
            long value = kv.value().getLong(0);
            if (value < 0L) {
                this.rowData.setRowKind(RowKind.DELETE);
            }
            this.count = Math.abs(value);
        }
    }
}

