/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.writer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;

@Internal
public class FileWriterBucketState {
    private final String bucketId;
    private final Path bucketPath;
    private final long inProgressFileCreationTime;
    @Nullable
    private final InProgressFileWriter.InProgressFileRecoverable inProgressFileRecoverable;
    private final Map<Long, List<InProgressFileWriter.PendingFileRecoverable>> pendingFileRecoverablesPerCheckpoint;

    public FileWriterBucketState(String bucketId, Path bucketPath, long inProgressFileCreationTime, @Nullable InProgressFileWriter.InProgressFileRecoverable inProgressFileRecoverable) {
        this(bucketId, bucketPath, inProgressFileCreationTime, inProgressFileRecoverable, new HashMap<Long, List<InProgressFileWriter.PendingFileRecoverable>>());
    }

    public FileWriterBucketState(String bucketId, Path bucketPath, long inProgressFileCreationTime, @Nullable InProgressFileWriter.InProgressFileRecoverable inProgressFileRecoverable, Map<Long, List<InProgressFileWriter.PendingFileRecoverable>> pendingFileRecoverablesPerCheckpoint) {
        this.bucketId = bucketId;
        this.bucketPath = bucketPath;
        this.inProgressFileCreationTime = inProgressFileCreationTime;
        this.inProgressFileRecoverable = inProgressFileRecoverable;
        this.pendingFileRecoverablesPerCheckpoint = pendingFileRecoverablesPerCheckpoint;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public Path getBucketPath() {
        return this.bucketPath;
    }

    public long getInProgressFileCreationTime() {
        return this.inProgressFileCreationTime;
    }

    @Nullable
    InProgressFileWriter.InProgressFileRecoverable getInProgressFileRecoverable() {
        return this.inProgressFileRecoverable;
    }

    boolean hasInProgressFileRecoverable() {
        return this.inProgressFileRecoverable != null;
    }

    public Map<Long, List<InProgressFileWriter.PendingFileRecoverable>> getPendingFileRecoverablesPerCheckpoint() {
        return this.pendingFileRecoverablesPerCheckpoint;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("BucketState for bucketId=").append(this.bucketId).append(" and bucketPath=").append(this.bucketPath);
        if (this.hasInProgressFileRecoverable()) {
            strBuilder.append(", has open part file created @ ").append(this.inProgressFileCreationTime);
        }
        if (!this.pendingFileRecoverablesPerCheckpoint.isEmpty()) {
            strBuilder.append(", has pending files for checkpoints: {");
            for (long checkpointId : this.pendingFileRecoverablesPerCheckpoint.keySet()) {
                strBuilder.append(checkpointId).append(' ');
            }
            strBuilder.append('}');
        }
        return strBuilder.toString();
    }
}

