/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferIndexAndChannel;
import org.apache.flink.util.Preconditions;

public class HsBufferContext {
    private final Buffer buffer;
    private final BufferIndexAndChannel bufferIndexAndChannel;
    private boolean released;
    private boolean spillStarted;
    private boolean consumed;
    @Nullable
    private CompletableFuture<Void> spilledFuture;

    public HsBufferContext(Buffer buffer, int bufferIndex, int subpartitionId) {
        this.bufferIndexAndChannel = new BufferIndexAndChannel(bufferIndex, subpartitionId);
        this.buffer = buffer;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public BufferIndexAndChannel getBufferIndexAndChannel() {
        return this.bufferIndexAndChannel;
    }

    public boolean isReleased() {
        return this.released;
    }

    public boolean isSpillStarted() {
        return this.spillStarted;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public Optional<CompletableFuture<Void>> getSpilledFuture() {
        return Optional.ofNullable(this.spilledFuture);
    }

    public void release() {
        if (this.isReleased()) {
            return;
        }
        this.released = true;
        this.buffer.recycleBuffer();
    }

    public boolean startSpilling(CompletableFuture<Void> spilledFuture) {
        if (this.isReleased() || this.isSpillStarted()) {
            return false;
        }
        this.spillStarted = true;
        this.spilledFuture = spilledFuture;
        this.buffer.retainBuffer();
        spilledFuture.thenRun(this.buffer::recycleBuffer);
        return true;
    }

    public void consumed() {
        Preconditions.checkState(!this.released, "Buffer is already released.");
        Preconditions.checkState(!this.consumed, "Consume buffer repeatedly is unexpected.");
        this.consumed = true;
        this.buffer.retainBuffer();
    }
}

