/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.io;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.AbstractChannelWriterOutputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.util.Preconditions;

public final class HeaderlessChannelWriterOutputView
extends AbstractChannelWriterOutputView {
    private final BlockChannelWriter<MemorySegment> writer;
    private int blockCount;

    public HeaderlessChannelWriterOutputView(BlockChannelWriter<MemorySegment> writer, List<MemorySegment> memory, int segmentSize) {
        super(segmentSize, 0);
        if (writer == null) {
            throw new NullPointerException();
        }
        this.writer = writer;
        Preconditions.checkNotNull(memory);
        LinkedBlockingQueue<MemorySegment> queue = writer.getReturnQueue();
        for (int i = memory.size() - 1; i >= 0; --i) {
            MemorySegment seg = memory.get(i);
            if (seg.size() != segmentSize) {
                throw new IllegalArgumentException("This segment are not of the specified size.");
            }
            queue.add(seg);
        }
        try {
            this.advance();
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
    }

    @Override
    public FileIOChannel getChannel() {
        return this.writer;
    }

    @Override
    public int close() throws IOException {
        if (!this.writer.isClosed()) {
            int currentPositionInSegment = this.getCurrentPositionInSegment();
            this.writer.writeBlock(this.getCurrentSegment());
            this.clear();
            this.writer.getReturnQueue().clear();
            this.writer.close();
            return currentPositionInSegment;
        }
        return -1;
    }

    @Override
    public int getBlockCount() {
        return this.blockCount;
    }

    @Override
    public long getNumBytes() throws IOException {
        return this.writer.getSize();
    }

    @Override
    public long getNumCompressedBytes() throws IOException {
        return this.writer.getSize();
    }

    @Override
    public MemorySegment nextSegment(MemorySegment current, int posInSegment) throws IOException {
        if (current != null) {
            this.writer.writeBlock(current);
        }
        MemorySegment next = this.writer.getNextReturnedBlock();
        ++this.blockCount;
        return next;
    }
}

