/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.time.Duration;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.table.api.PlannerConfig;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class TableConfig
implements WritableConfig,
ReadableConfig {
    private PlannerConfig plannerConfig = PlannerConfig.EMPTY_CONFIG;
    private final Configuration configuration = new Configuration();
    private ReadableConfig rootConfiguration = new Configuration();

    @Deprecated
    public TableConfig() {
    }

    @Override
    public <T> TableConfig set(ConfigOption<T> option, T value) {
        this.configuration.set((ConfigOption)option, (Object)value);
        return this;
    }

    public TableConfig set(String key, String value) {
        this.configuration.setString(key, value);
        return this;
    }

    @Override
    public <T> T get(ConfigOption<T> option) {
        return (T)this.configuration.getOptional(option).orElseGet(() -> this.rootConfiguration.get(option));
    }

    @Override
    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional<T> tableValue = this.configuration.getOptional(option);
        if (tableValue.isPresent()) {
            return tableValue;
        }
        return this.rootConfiguration.getOptional(option);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Internal
    public ReadableConfig getRootConfiguration() {
        return this.rootConfiguration;
    }

    public void addConfiguration(Configuration configuration) {
        Preconditions.checkNotNull(configuration);
        this.configuration.addAll(configuration);
    }

    public SqlDialect getSqlDialect() {
        return SqlDialect.valueOf(this.get(TableConfigOptions.TABLE_SQL_DIALECT).toUpperCase());
    }

    public void setSqlDialect(SqlDialect sqlDialect) {
        this.set((ConfigOption)TableConfigOptions.TABLE_SQL_DIALECT, (Object)sqlDialect.name().toLowerCase());
    }

    public ZoneId getLocalTimeZone() {
        String zone = this.configuration.getString(TableConfigOptions.LOCAL_TIME_ZONE);
        this.validateTimeZone(zone);
        return TableConfigOptions.LOCAL_TIME_ZONE.defaultValue().equals(zone) ? ZoneId.systemDefault() : ZoneId.of(zone);
    }

    public void setLocalTimeZone(ZoneId zoneId) {
        this.validateTimeZone(zoneId.toString());
        this.configuration.setString(TableConfigOptions.LOCAL_TIME_ZONE, zoneId.toString());
    }

    private void validateTimeZone(String zone) {
        String zoneId = zone.toUpperCase();
        if (zoneId.startsWith("UTC+") || zoneId.startsWith("UTC-") || ZoneId.SHORT_IDS.containsKey(zoneId)) {
            throw new IllegalArgumentException(String.format("The supported Zone ID is either a full name such as 'America/Los_Angeles', or a custom timezone id such as 'GMT-08:00', but configured Zone ID is '%s'.", zone));
        }
    }

    public PlannerConfig getPlannerConfig() {
        return this.plannerConfig;
    }

    public void setPlannerConfig(PlannerConfig plannerConfig) {
        this.plannerConfig = Preconditions.checkNotNull(plannerConfig);
    }

    public Integer getMaxGeneratedCodeLength() {
        return this.configuration.getInteger(TableConfigOptions.MAX_LENGTH_GENERATED_CODE);
    }

    public void setMaxGeneratedCodeLength(Integer maxGeneratedCodeLength) {
        this.configuration.setInteger(TableConfigOptions.MAX_LENGTH_GENERATED_CODE, (int)maxGeneratedCodeLength);
    }

    @Deprecated
    public void setIdleStateRetentionTime(Time minTime, Time maxTime) {
        if (maxTime.toMilliseconds() - minTime.toMilliseconds() < 300000L && (maxTime.toMilliseconds() != 0L || minTime.toMilliseconds() != 0L)) {
            throw new IllegalArgumentException("Difference between minTime: " + minTime + " and maxTime: " + maxTime + " should be at least 5 minutes.");
        }
        this.setIdleStateRetention(Duration.ofMillis(minTime.toMilliseconds()));
    }

    public void setIdleStateRetention(Duration duration) {
        this.configuration.set((ConfigOption)ExecutionConfigOptions.IDLE_STATE_RETENTION, duration);
    }

    @Deprecated
    public long getMinIdleStateRetentionTime() {
        return this.configuration.get(ExecutionConfigOptions.IDLE_STATE_RETENTION).toMillis();
    }

    @Deprecated
    public long getMaxIdleStateRetentionTime() {
        return this.getMinIdleStateRetentionTime() * 3L / 2L;
    }

    public Duration getIdleStateRetention() {
        return this.configuration.get(ExecutionConfigOptions.IDLE_STATE_RETENTION);
    }

    public void addJobParameter(String key, String value) {
        Map params = this.getOptional(PipelineOptions.GLOBAL_JOB_PARAMETERS).map(HashMap::new).orElseGet(HashMap::new);
        params.put(key, value);
        this.set((ConfigOption)PipelineOptions.GLOBAL_JOB_PARAMETERS, params);
    }

    @Internal
    public void setRootConfiguration(ReadableConfig rootConfiguration) {
        this.rootConfiguration = rootConfiguration;
    }

    public static TableConfig getDefault() {
        return new TableConfig();
    }
}

