/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.parquet;

import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.store.format.FileFormatFactory;
import org.apache.flink.table.store.format.parquet.ParquetFileFormat;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class ParquetFileFormatFactory
implements FileFormatFactory {
    public static final String IDENTIFIER = "parquet";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public ParquetFileFormat create(Configuration formatOptions) {
        return new ParquetFileFormat(this.supplyDefaultOptions(formatOptions));
    }

    private Configuration supplyDefaultOptions(Configuration options) {
        String compression = "parquet.compression".replaceFirst(String.format("^%s.", IDENTIFIER), "");
        if (!options.containsKey(compression)) {
            Properties properties = new Properties();
            options.addAllToProperties(properties);
            properties.setProperty(compression, CompressionCodecName.SNAPPY.name());
            Configuration newOptions = new Configuration();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> newOptions.setString(k.toString(), v.toString())));
            return newOptions;
        }
        return options;
    }
}

