/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.log;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.flink.table.store.table.sink.LogSinkFunction;

public class LogWriteCallback
implements LogSinkFunction.WriteCallback {
    private final ConcurrentHashMap<Integer, LongAccumulator> offsetMap = new ConcurrentHashMap();

    @Override
    public void onCompletion(int bucket, long offset) {
        LongAccumulator acc = this.offsetMap.get(bucket);
        if (acc == null) {
            acc = this.offsetMap.computeIfAbsent(bucket, k -> new LongAccumulator(Long::max, 0L));
        }
        acc.accumulate(offset + 1L);
    }

    public Map<Integer, Long> offsets() {
        HashMap<Integer, Long> offsets = new HashMap<Integer, Long>();
        this.offsetMap.forEach((k, v) -> offsets.put((Integer)k, v.longValue()));
        return offsets;
    }
}

