/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blocklist;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public class BlockedNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final String cause;
    private final long endTimestamp;

    public BlockedNode(String nodeId, String cause, long endTimestamp) {
        this.nodeId = Preconditions.checkNotNull(nodeId);
        this.cause = Preconditions.checkNotNull(cause);
        this.endTimestamp = endTimestamp;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getCause() {
        return this.cause;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockedNode) {
            BlockedNode other = (BlockedNode)obj;
            return this.nodeId.equals(other.nodeId) && this.cause.equals(other.cause) && this.endTimestamp == other.endTimestamp;
        }
        return false;
    }

    public String toString() {
        return "BlockedNode{id:" + this.nodeId + ",cause:" + this.cause + ",endTimestamp:" + this.endTimestamp + "}";
    }
}

