/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import org.apache.flink.util.function.FunctionWithException;

public class DeterminismEnvelope<T> {
    private final T value;
    private final boolean isDeterministic;

    private DeterminismEnvelope(T value, boolean isDeterministic) {
        this.value = value;
        this.isDeterministic = isDeterministic;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public T unwrap() {
        return this.value;
    }

    public <V, E extends Exception> DeterminismEnvelope<V> map(FunctionWithException<? super T, ? extends V, E> mapper) throws E {
        V newValue = mapper.apply(this.value);
        if (this.isDeterministic) {
            return DeterminismEnvelope.deterministicValue(newValue);
        }
        return DeterminismEnvelope.nondeterministicValue(newValue);
    }

    public static <T> DeterminismEnvelope<T> deterministicValue(T value) {
        return new DeterminismEnvelope<T>(value, true);
    }

    public static <T> DeterminismEnvelope<T> nondeterministicValue(T value) {
        return new DeterminismEnvelope<T>(value, false);
    }

    public String toString() {
        return this.value.toString();
    }
}

